<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class CreatorNavigationVisibilityTest extends TestCase
{
    use RefreshDatabase;

    /** @test */
    public function creator_user_can_see_navigation_links()
    {
        // Create a creator user
        $creator = User::factory()->create([
            'email' => 'creator@demo.local',
            'password' => bcrypt('password123'),
        ]);
        
        // Assign creator role
        $creator->assignRole('creator');
        
        // Login as creator
        $this->actingAs($creator);
        
        // Visit the creator dashboard
        $response = $this->get(route('creator.dashboard'));
        
        // Assert the response is successful
        $response->assertStatus(200);
        
        // Assert that the navigation links are visible
        $response->assertSee('Dashboard');
        $response->assertSee('Connections');
        $response->assertSee('Providers');
        $response->assertSee('Profile');
        $response->assertSee('Content');
        $response->assertSee('Settings');
        $response->assertSee('Sync Now');
        
        // Test that each link returns HTTP 200
        $this->get(route('creator.dashboard'))->assertStatus(200);
        $this->get(route('creator.connections.index'))->assertStatus(200);
        $this->get(route('creator.providers.index'))->assertStatus(200);
        $this->get(route('creator.profile.edit'))->assertStatus(200);
        $this->get(route('creator.content.index'))->assertStatus(200);
        $this->get(route('creator.settings.social'))->assertStatus(200);
        $this->post(route('creator.dashboard.sync'))->assertStatus(302); // Redirect after POST
    }
}