<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class BrandNavigationVisibilityTest extends TestCase
{
    use RefreshDatabase;

    /** @test */
    public function brand_admin_user_can_see_navigation_links()
    {
        // Create a tenant
        $tenant = \App\Models\Tenant::factory()->create();
        
        // Create a brand
        $brand = \App\Models\Brand::factory()->create([
            'tenant_id' => $tenant->id,
        ]);
        
        // Create a brand admin user
        $brandAdmin = User::factory()->create([
            'email' => 'brand@demo.local',
            'password' => bcrypt('password123'),
            'tenant_id' => $tenant->id,
            'brand_id' => $brand->id,
        ]);
        
        // Assign brand_admin role
        $brandAdmin->assignRole('brand_admin');
        
        // Login as brand admin
        $this->actingAs($brandAdmin);
        
        // Visit the brand dashboard
        $response = $this->get(route('brand.dashboard'));
        
        // Assert the response is successful
        $response->assertStatus(200);
        
        // Assert that the navigation links are visible
        $response->assertSee('Dashboard');
        $response->assertSee('Connections');
        $response->assertSee('Profile');
        $response->assertSee('Content');
        $response->assertSee('Settings');
        $response->assertSee('Sync Now');
        
        // Test that each link returns HTTP 200
        $this->get(route('brand.dashboard'))->assertStatus(200);
        $this->get(route('brand.connections.index'))->assertStatus(200);
        $this->get(route('profile.edit'))->assertStatus(200);
        $this->get(route('brand.content.pending'))->assertStatus(200);
        // Settings is a dropdown, so we test the sub-item
        // Sync Now is a POST route, so we test with POST
        $this->post(route('brand.dashboard.sync'))->assertStatus(302); // Redirect after POST
    }
}