<?php

namespace Tests\Feature;

use App\Models\Brand;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AnalyticsEndpointTest extends TestCase
{
    use RefreshDatabase;

    protected $brandUser;
    protected $brand;

    protected function setUp(): void
    {
        parent::setUp();

        // Create a brand
        $this->brand = Brand::factory()->create();

        // Create a brand admin user
        $this->brandUser = User::factory()->create([
            'brand_id' => $this->brand->id,
        ]);
        $this->brandUser->assignRole('brand_admin');
    }

    /** @test */
    public function brand_admin_can_view_analytics_dashboard()
    {
        $response = $this->actingAs($this->brandUser)
            ->get(route('brand.analytics.index'));

        $response->assertStatus(200);
        $response->assertViewIs('brand.analytics.index');
    }

    /** @test */
    public function brand_admin_can_get_analytics_data()
    {
        $response = $this->actingAs($this->brandUser)
            ->get(route('brand.analytics.data'));

        $response->assertStatus(200);
        $response->assertJsonStructure([
            'labels',
            'data',
        ]);
    }

    /** @test */
    public function brand_admin_can_get_analytics_data_with_filters()
    {
        $response = $this->actingAs($this->brandUser)
            ->get(route('brand.analytics.data', [
                'provider' => 'youtube',
                'days' => 7,
            ]));

        $response->assertStatus(200);
        $response->assertJsonStructure([
            'labels',
            'data',
        ]);
    }

    /** @test */
    public function creator_can_view_analytics_dashboard()
    {
        // Create a creator user
        $creatorUser = User::factory()->create();
        $creatorUser->assignRole('creator');

        $response = $this->actingAs($creatorUser)
            ->get(route('creator.analytics.index'));

        $response->assertStatus(200);
        $response->assertViewIs('creator.analytics.index');
    }

    /** @test */
    public function creator_can_get_analytics_data()
    {
        // Create a creator user
        $creatorUser = User::factory()->create();
        $creatorUser->assignRole('creator');

        $response = $this->actingAs($creatorUser)
            ->get(route('creator.analytics.data'));

        $response->assertStatus(200);
        $response->assertJsonStructure([
            'labels',
            'data',
        ]);
    }
}