<section id="faq" class="py-20 bg-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-4xl font-bold text-gray-900 mb-4">
                Frequently Asked Questions
            </h2>
            <p class="text-xl text-gray-600">
                Everything you need to know about our plans and pricing
            </p>
        </div>

        <div class="space-y-4" x-data="{ openFaq: null }">
            <!-- FAQ Item 1 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 1 ? null : 1"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">Can I change my plan later?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 1 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 1" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    Yes! You can upgrade or downgrade your plan at any time. Upgrades take effect immediately, while downgrades apply at the end of your current billing period. You'll be charged or credited the prorated difference.
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 2 ? null : 2"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">What payment methods do you accept?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 2 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 2" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    We accept all major credit/debit cards (Visa, Mastercard, American Express), UPI, net banking, and digital wallets through our secure payment partner Razorpay. All transactions are encrypted and PCI DSS compliant.
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 3 ? null : 3"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">Can I cancel anytime?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 3 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 3" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    Absolutely! You can cancel your subscription at any time with no questions asked. You'll continue to have access to all features until the end of your current billing period. No cancellation fees or hidden charges.
                </div>
            </div>

            <!-- FAQ Item 4 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 4 ? null : 4"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">Do you offer refunds?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 4 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 4" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    Yes, we offer a 14-day money-back guarantee on all paid plans. If you're not satisfied within the first 14 days, contact our support team for a full refund. After 14 days, refunds are evaluated on a case-by-case basis.
                </div>
            </div>

            <!-- FAQ Item 5 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 5 ? null : 5"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">Is my data secure?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 5 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 5" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    Absolutely. We use bank-level encryption (256-bit SSL) for all data transmission. Your data is stored in secure, SOC 2 compliant data centers. We're GDPR compliant and never sell your data to third parties.
                </div>
            </div>

            <!-- FAQ Item 6 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 6 ? null : 6"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">Do you offer enterprise plans?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 6 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 6" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    Yes! Our Enterprise plan includes unlimited everything, white-label options, dedicated account manager, custom integrations, SLA guarantees, and priority support. Contact our sales team for custom pricing.
                </div>
            </div>

            <!-- FAQ Item 7 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 7 ? null : 7"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">What's included in the free trial?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 7 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 7" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    Your 14-day free trial includes full access to all features of your chosen plan. No credit card required to start. You can cancel anytime during the trial with no charges.
                </div>
            </div>

            <!-- FAQ Item 8 -->
            <div class="bg-gray-50 rounded-lg overflow-hidden">
                <button @click="openFaq = openFaq === 8 ? null : 8"
                        class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-100 transition">
                    <span class="font-semibold text-gray-900">How does billing work?</span>
                    <svg class="w-5 h-5 text-gray-500 transition-transform" 
                         :class="openFaq === 8 ? 'rotate-180' : ''"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="openFaq === 8" 
                     x-cloak
                     x-transition
                     class="px-6 pb-4 text-gray-600">
                    Billing is automatic and occurs monthly or yearly based on your chosen plan. You'll receive an invoice via email after each payment. You can view all invoices in your account dashboard.
                </div>
            </div>
        </div>

        <!-- Still have questions? -->
        <div class="mt-12 text-center">
            <p class="text-gray-600 mb-4">Still have questions?</p>
            <a href="#contact" class="text-blue-600 font-semibold hover:text-blue-700 transition">
                Contact our support team →
            </a>
        </div>
    </div>
</section><?php /**PATH C:\xampp\htdocs\AI business market\Laravel\resources\views/components/marketing/faq.blade.php ENDPATH**/ ?>