@extends('layouts.marketing')

@section('title', 'Pricing - AI Business Market')
@section('description', 'Choose the perfect plan for your business. Start with a 14-day free trial. No credit card required.')

@push('structured-data')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Product",
    "name": "AI Business Market",
    "description": "Creator campaign management platform with AI",
    "offers": [
        @foreach($plans as $index => $plan)
        {
            "@type": "Offer",
            "name": "{{ $plan->name }}",
            "price": "{{ $plan->price }}",
            "priceCurrency": "{{ $plan->currency }}",
            "availability": "https://schema.org/InStock",
            "url": "{{ route('subscription.checkout', $plan) }}"
        }{{ $index < count($plans) - 1 ? ',' : '' }}
        @endforeach
    ]
}
</script>
@endpush

@section('content')
<div x-data="{ interval: '{{ $interval }}', selectedRole: '{{ $selectedRole }}' }">
    <!-- Pricing Header -->
    <section class="bg-gradient-to-br from-blue-50 to-indigo-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h1 class="text-5xl font-bold text-gray-900 mb-6">
                Simple, Transparent Pricing
            </h1>
            <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
                Choose the plan that fits your needs. All plans include a 14-day free trial. No credit card required.
            </p>
            
            <!-- Interval Toggle -->
            <div class="inline-flex items-center bg-white rounded-full p-1 shadow-lg mb-6">
                <button @click="interval = 'monthly'" 
                        :class="interval === 'monthly' ? 'bg-blue-600 text-white' : 'text-gray-600 hover:text-gray-900'"
                        class="px-6 py-2 rounded-full font-semibold transition-all duration-200">
                    Monthly
                </button>
                <button @click="interval = 'yearly'" 
                        :class="interval === 'yearly' ? 'bg-blue-600 text-white' : 'text-gray-600 hover:text-gray-900'"
                        class="px-6 py-2 rounded-full font-semibold transition-all duration-200 flex items-center">
                    Yearly
                    <span class="ml-2 text-xs bg-green-500 text-white px-2 py-1 rounded-full">
                        Save 20%
                    </span>
                </button>
            </div>
            
            <!-- Role Filter -->
            <div class="mt-4">
                <label class="text-sm text-gray-600 mr-3">I am a:</label>
                <select x-model="selectedRole" 
                        @change="gtag('event', 'select_content', {'content_type': 'role', 'item_id': selectedRole});"
                        class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    <option value="all">Show All Plans</option>
                    <option value="brand">Brand / Business</option>
                    <option value="creator">Creator / Influencer</option>
                    <option value="agency">Agency</option>
                </select>
            </div>
        </div>
    </section>

    <!-- Pricing Cards -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
                @foreach($plans as $plan)
                    <div x-bind:class="interval">
                        <x-marketing.pricing-card 
                            :plan="$plan" 
                            :featured="$plan->slug === 'pro'"
                            interval="monthly"
                            :selectedRole="$selectedRole"
                        />
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Trust Badges -->
    <section class="py-12 bg-white border-y border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <x-marketing.trust-badges />
        </div>
    </section>

    <!-- Feature Comparison Table -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-center mb-12">Compare All Features</h2>
            
            <!-- Desktop Table -->
            <div class="hidden lg:block bg-white rounded-2xl shadow-xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-sm font-semibold text-gray-900 w-1/3">Features</th>
                                @foreach($plans as $plan)
                                    <th class="px-6 py-4 text-center text-sm font-semibold text-gray-900">
                                        {{ $plan->name }}
                                    </th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <tr class="bg-gray-50">
                                <td colspan="{{ count($plans) + 1 }}" class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase">
                                    Core Features
                                </td>
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Social Accounts</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center text-sm font-medium">
                                        {{ $plan->max_social_accounts === -1 ? '∞' : $plan->max_social_accounts }}
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Active Campaigns</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center text-sm font-medium">
                                        {{ $plan->max_campaigns === -1 ? '∞' : ($plan->max_campaigns === 0 ? '—' : $plan->max_campaigns) }}
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">AI Proposals / Month</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center text-sm font-medium">
                                        {{ $plan->max_proposals === -1 ? '∞' : $plan->max_proposals }}
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Content Ideas / Month</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center text-sm font-medium">
                                        {{ $plan->max_content_ideas_per_month === -1 ? '∞' : $plan->max_content_ideas_per_month }}
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Reels / Month</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center text-sm font-medium">
                                        {{ $plan->max_reels_per_month === -1 ? '∞' : ($plan->max_reels_per_month === 0 ? '—' : $plan->max_reels_per_month) }}
                                    </td>
                                @endforeach
                            </tr>
                            
                            <tr class="bg-gray-50">
                                <td colspan="{{ count($plans) + 1 }}" class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase">
                                    Advanced Features
                                </td>
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Ads Manager</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center">
                                        @if($plan->has_ads_manager)
                                            <svg class="w-5 h-5 text-green-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                            </svg>
                                        @else
                                            <span class="text-gray-400">—</span>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Analytics Dashboard</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center">
                                        @if($plan->has_analytics)
                                            <svg class="w-5 h-5 text-green-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                            </svg>
                                        @else
                                            <span class="text-gray-400">—</span>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Competitor Insights</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center">
                                        @if($plan->has_competitor_insights)
                                            <svg class="w-5 h-5 text-green-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                            </svg>
                                        @else
                                            <span class="text-gray-400">—</span>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">White Label</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center">
                                        @if($plan->has_white_label)
                                            <svg class="w-5 h-5 text-green-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                            </svg>
                                        @else
                                            <span class="text-gray-400">—</span>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">Priority Support</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center">
                                        @if($plan->has_priority_support)
                                            <svg class="w-5 h-5 text-green-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                            </svg>
                                        @else
                                            <span class="text-gray-400">—</span>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">API Access</td>
                                @foreach($plans as $plan)
                                    <td class="px-6 py-4 text-center">
                                        @if($plan->has_api_access)
                                            <svg class="w-5 h-5 text-green-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                            </svg>
                                        @else
                                            <span class="text-gray-400">—</span>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Mobile Accordion -->
            <div class="lg:hidden space-y-4">
                @foreach($plans as $plan)
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                        <div class="bg-gradient-to-r {{ $plan->slug === 'starter' ? 'from-gray-500 to-gray-600' : ($plan->slug === 'pro' ? 'from-blue-500 to-blue-600' : ($plan->slug === 'business' ? 'from-purple-500 to-purple-600' : 'from-yellow-500 to-yellow-600')) }} text-white p-4">
                            <h3 class="font-bold text-lg">{{ $plan->name }}</h3>
                            <div class="text-2xl font-bold mt-2">{{ $plan->formatted_price }}</div>
                        </div>
                        <div class="p-4 space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span>Social Accounts:</span>
                                <span class="font-medium">{{ $plan->max_social_accounts === -1 ? '∞' : $plan->max_social_accounts }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span>Campaigns:</span>
                                <span class="font-medium">{{ $plan->max_campaigns === -1 ? '∞' : ($plan->max_campaigns === 0 ? '—' : $plan->max_campaigns) }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span>Proposals/mo:</span>
                                <span class="font-medium">{{ $plan->max_proposals === -1 ? '∞' : $plan->max_proposals }}</span>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <x-marketing.faq />
    
    <!-- Final CTA -->
    <section class="py-20 bg-gradient-to-r from-blue-600 to-purple-600 text-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-4xl font-bold mb-6">Ready to Get Started?</h2>
            <p class="text-xl mb-8 opacity-90">
                Join 500+ brands and 2,000+ creators already using AI Business Market
            </p>
            <a href="{{ route('register') }}" 
               onclick="gtag('event', 'click', {'event_category': 'Final CTA', 'event_label': 'Pricing Page'});"
               class="inline-block bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold text-lg hover:bg-gray-100 transition transform hover:scale-105 shadow-xl">
                Start Your 14-Day Free Trial
            </a>
            <p class="text-sm mt-4 opacity-75">No credit card required • Cancel anytime</p>
        </div>
    </section>

    <!-- Sticky CTA -->
    <x-marketing.sticky-cta :plan="$plans->where('slug', 'pro')->first()" />
</div>
@endsection