@extends('adminlte::page')

@section('title', 'Scheduled Reel Details')

@section('content_header')
    <h1>Scheduled Reel Details</h1>
@stop

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Reel #{{ $reel->id }}</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h4>Reel Information</h4>
                        <table class="table table-bordered">
                            <tr>
                                <th>Template</th>
                                <td>{{ $reel->template }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($reel->status === 'draft')
                                        <span class="badge badge-secondary">Draft</span>
                                    @elseif($reel->status === 'scheduled')
                                        <span class="badge badge-info">Scheduled</span>
                                    @elseif($reel->status === 'queued')
                                        <span class="badge badge-warning">Queued</span>
                                    @elseif($reel->status === 'posting')
                                        <span class="badge badge-primary">Posting</span>
                                    @elseif($reel->status === 'posted')
                                        <span class="badge badge-success">Posted</span>
                                    @elseif($reel->status === 'failed')
                                        <span class="badge badge-danger">Failed</span>
                                    @elseif($reel->status === 'cancelled')
                                        <span class="badge badge-dark">Cancelled</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Scheduled At</th>
                                <td>{{ $reel->scheduled_at ? $reel->scheduled_at->format('Y-m-d H:i') : 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Timezone</th>
                                <td>{{ $reel->timezone ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Created By</th>
                                <td>{{ $reel->createdBy->name ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Created At</th>
                                <td>{{ $reel->created_at->format('Y-m-d H:i') }}</td>
                            </tr>
                            <tr>
                                <th>Attempt Count</th>
                                <td>{{ $reel->attempt_count }}</td>
                            </tr>
                        </table>
                    </div>
                    
                    <div class="col-md-6">
                        <h4>Options</h4>
                        <table class="table table-bordered">
                            @if(is_array($reel->options) || is_object($reel->options))
                                @foreach($reel->options as $key => $value)
                                    <tr>
                                        <th>{{ ucfirst($key) }}</th>
                                        <td>{{ is_array($value) ? json_encode($value) : $value }}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="2">No options available</td>
                                </tr>
                            @endif
                        </table>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <h4>Source Inputs</h4>
                        @if(is_array($reel->source_inputs) || is_object($reel->source_inputs))
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Provider</th>
                                        <th>Source URL</th>
                                        <th>Meta</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($reel->source_inputs as $input)
                                        <tr>
                                            <td>{{ $input['provider'] ?? 'N/A' }}</td>
                                            <td>{{ $input['source_url'] ?? 'N/A' }}</td>
                                            <td>
                                                @if(isset($input['meta']) && (is_array($input['meta']) || is_object($input['meta'])))
                                                    <ul>
                                                        @foreach($input['meta'] as $metaKey => $metaValue)
                                                            <li>{{ ucfirst($metaKey) }}: {{ is_array($metaValue) ? json_encode($metaValue) : $metaValue }}</li>
                                                        @endforeach
                                                    </ul>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @else
                            <p>No source inputs available</p>
                        @endif
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <h4>Post Attempts</h4>
                        @if($reel->postAttempts->count() > 0)
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Provider</th>
                                        <th>Created At</th>
                                        <th>Status</th>
                                        <th>Response Summary</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($reel->postAttempts as $attempt)
                                        <tr>
                                            <td>{{ $attempt->provider }}</td>
                                            <td>{{ $attempt->created_at->format('Y-m-d H:i') }}</td>
                                            <td>{{ $attempt->status }}</td>
                                            <td>{{ $attempt->response_summary ?? 'N/A' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @else
                            <p>No post attempts recorded yet.</p>
                        @endif
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <h4>Actions</h4>
                        <div class="btn-group" role="group">
                            @if($reel->status === 'scheduled' || $reel->status === 'draft')
                                <form action="{{ route('creator.reels.post-now', $reel) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-success">
                                        <i class="fas fa-bolt"></i> Post Now
                                    </button>
                                </form>
                            @endif
                            
                            @if($reel->status === 'scheduled' || $reel->status === 'draft')
                                <a href="{{ route('creator.reels.create') }}" class="btn btn-warning">
                                    <i class="fas fa-edit"></i> Reschedule
                                </a>
                            @endif
                            
                            @if($reel->status === 'scheduled' || $reel->status === 'draft')
                                <form action="{{ route('creator.reels.cancel', $reel) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-danger">
                                        <i class="fas fa-times"></i> Cancel
                                    </button>
                                </form>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop