@extends('adminlte::page')

@section('title', 'Edit Profile')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Edit Profile</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.profile.edit') }}">Profile</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        @if(session('status') === 'profile-updated')
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            Profile updated successfully.
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif

        @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Profile Information</h3>
                    </div>
                    <div class="card-body">
                        <form method="post" action="{{ route('creator.profile.update') }}" enctype="multipart/form-data">
                            @csrf
                            @method('patch')

                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" id="name" class="form-control" value="{{ old('name', $user->name) }}" required>
                            </div>

                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" name="email" id="email" class="form-control" value="{{ old('email', $user->email) }}" required>
                            </div>

                            <div class="form-group">
                                <label for="bio">Bio</label>
                                <textarea name="bio" id="bio" class="form-control" rows="4" placeholder="Tell us about yourself...">{{ old('bio', $user->meta['bio'] ?? '') }}</textarea>
                                <small class="form-text text-muted">Minimum 10 characters, maximum 1000 characters</small>
                            </div>

                            <div class="form-group">
                                <label for="influencer_type">Influencer Type</label>
                                <select name="influencer_type" id="influencer_type" class="form-control">
                                    <option value="">Select Influencer Type</option>
                                    <option value="Lifestyle" {{ old('influencer_type', $user->influencer_type) == 'Lifestyle' ? 'selected' : '' }}>Lifestyle</option>
                                    <option value="Tech" {{ old('influencer_type', $user->influencer_type) == 'Tech' ? 'selected' : '' }}>Tech</option>
                                    <option value="Gaming" {{ old('influencer_type', $user->influencer_type) == 'Gaming' ? 'selected' : '' }}>Gaming</option>
                                    <option value="Beauty" {{ old('influencer_type', $user->influencer_type) == 'Beauty' ? 'selected' : '' }}>Beauty</option>
                                    <option value="Fitness" {{ old('influencer_type', $user->influencer_type) == 'Fitness' ? 'selected' : '' }}>Fitness</option>
                                    <option value="Travel" {{ old('influencer_type', $user->influencer_type) == 'Travel' ? 'selected' : '' }}>Travel</option>
                                    <option value="Food" {{ old('influencer_type', $user->influencer_type) == 'Food' ? 'selected' : '' }}>Food</option>
                                    <option value="Education" {{ old('influencer_type', $user->influencer_type) == 'Education' ? 'selected' : '' }}>Education</option>
                                    <option value="Business" {{ old('influencer_type', $user->influencer_type) == 'Business' ? 'selected' : '' }}>Business</option>
                                    <option value="Entertainment" {{ old('influencer_type', $user->influencer_type) == 'Entertainment' ? 'selected' : '' }}>Entertainment</option>
                                    <option value="Sports" {{ old('influencer_type', $user->influencer_type) == 'Sports' ? 'selected' : '' }}>Sports</option>
                                    <option value="Other" {{ old('influencer_type', $user->influencer_type) == 'Other' ? 'selected' : '' }}>Other (Please specify)</option>
                                </select>
                            </div>

                            <div class="form-group" id="custom_influencer_type_group" style="{{ old('influencer_type', $user->influencer_type) == 'Other' ? 'display: block;' : 'display: none;' }}">
                                <label for="influencer_type_custom">Please Specify</label>
                                <input type="text" name="influencer_type_custom" id="influencer_type_custom" class="form-control" value="{{ old('influencer_type_custom', $user->influencer_type_custom ?? '') }}" placeholder="Enter your influencer type">
                                <small class="form-text text-muted">Minimum 2 characters, maximum 100 characters</small>
                            </div>

                            <div class="form-group">
                                <label for="niche">Content Niche/Categories</label>
                                <select name="niche[]" id="niche" class="form-control select2" multiple="multiple" data-placeholder="Select your content niches">
                                    @php
                                    $niches = ['Lifestyle', 'Tech', 'Gaming', 'Beauty', 'Fitness', 'Travel', 'Food', 'Education', 'Business', 'Entertainment', 'Sports', 'Fashion', 'Health', 'Music', 'Art', 'Photography', 'Comedy', 'DIY', 'Parenting', 'Finance'];
                                    $userNiches = old('niche', $user->meta['niche'] ?? []);
                                    @endphp
                                    @foreach($niches as $niche)
                                    <option value="{{ $niche }}" {{ in_array($niche, (array)$userNiches) ? 'selected' : '' }}>{{ $niche }}</option>
                                    @endforeach
                                </select>
                                <small class="form-text text-muted">Select one or more categories that describe your content</small>
                            </div>

                            <div class="form-group">
                                <label for="audience_age">Primary Audience Age Range</label>
                                <select name="audience_age" id="audience_age" class="form-control">
                                    <option value="">Select Age Range</option>
                                    <option value="13-17" {{ old('audience_age', $user->meta['audience_age'] ?? '') == '13-17' ? 'selected' : '' }}>13-17</option>
                                    <option value="18-24" {{ old('audience_age', $user->meta['audience_age'] ?? '') == '18-24' ? 'selected' : '' }}>18-24</option>
                                    <option value="25-34" {{ old('audience_age', $user->meta['audience_age'] ?? '') == '25-34' ? 'selected' : '' }}>25-34</option>
                                    <option value="35-44" {{ old('audience_age', $user->meta['audience_age'] ?? '') == '35-44' ? 'selected' : '' }}>35-44</option>
                                    <option value="45-54" {{ old('audience_age', $user->meta['audience_age'] ?? '') == '45-54' ? 'selected' : '' }}>45-54</option>
                                    <option value="55+" {{ old('audience_age', $user->meta['audience_age'] ?? '') == '55+' ? 'selected' : '' }}>55+</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="audience_gender">Primary Audience Gender</label>
                                <select name="audience_gender" id="audience_gender" class="form-control">
                                    <option value="">Select Gender Distribution</option>
                                    <option value="mostly_male" {{ old('audience_gender', $user->meta['audience_gender'] ?? '') == 'mostly_male' ? 'selected' : '' }}>Mostly Male (70%+)</option>
                                    <option value="mostly_female" {{ old('audience_gender', $user->meta['audience_gender'] ?? '') == 'mostly_female' ? 'selected' : '' }}>Mostly Female (70%+)</option>
                                    <option value="balanced" {{ old('audience_gender', $user->meta['audience_gender'] ?? '') == 'balanced' ? 'selected' : '' }}>Balanced (40-60%)</option>
                                    <option value="mixed" {{ old('audience_gender', $user->meta['audience_gender'] ?? '') == 'mixed' ? 'selected' : '' }}>Mixed</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="audience_location">Primary Audience Location</label>
                                <select name="audience_location[]" id="audience_location" class="form-control select2" multiple="multiple" data-placeholder="Select primary locations">
                                    @php
                                    $locations = ['United States', 'United Kingdom', 'Canada', 'Australia', 'India', 'Germany', 'France', 'Spain', 'Italy', 'Brazil', 'Mexico', 'Japan', 'South Korea', 'Other'];
                                    $userLocations = old('audience_location', $user->meta['audience_location'] ?? []);
                                    @endphp
                                    @foreach($locations as $location)
                                    <option value="{{ $location }}" {{ in_array($location, (array)$userLocations) ? 'selected' : '' }}>{{ $location }}</option>
                                    @endforeach
                                </select>
                                <small class="form-text text-muted">Select top 3-5 countries where your audience is located</small>
                            </div>

                            <div class="form-group">
                                <label for="avatar">Avatar</label>
                                <div class="custom-file">
                                    <input type="file" name="avatar" id="avatar" class="custom-file-input" accept="image/*">
                                    <label class="custom-file-label" for="avatar">Choose file</label>
                                </div>
                                <small class="form-text text-muted">JPG, PNG, GIF up to 2MB</small>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Current Avatar</h3>
                    </div>
                    <div class="card-body text-center">
                        @if(!empty($user->meta['avatar']))
                        <img src="{{ asset('storage/' . $user->meta['avatar']) }}" alt="Avatar" class="img-fluid rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover;">
                        @else
                        <div class="bg-light border rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" style="width: 150px; height: 150px;">
                            <i class="fas fa-user fa-3x text-muted"></i>
                        </div>
                        @endif
                        <p class="text-muted">Current profile picture</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.5.2/dist/select2-bootstrap4.min.css" rel="stylesheet" />
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2 for multi-select dropdowns
    $('.select2').select2({
        theme: 'bootstrap4',
        width: '100%'
    });
    
    // Update file input label with selected file name
    document.getElementById('avatar').addEventListener('change', function(e) {
        var fileName = e.target.files[0] ? e.target.files[0].name : 'Choose file';
        var nextSibling = e.target.nextElementSibling;
        nextSibling.innerText = fileName;
    });
    
    // Handle influencer type dropdown change
    const influencerTypeSelect = document.getElementById('influencer_type');
    const customInfluencerTypeGroup = document.getElementById('custom_influencer_type_group');
    
    if (influencerTypeSelect && customInfluencerTypeGroup) {
        influencerTypeSelect.addEventListener('change', function() {
            if (this.value === 'Other') {
                customInfluencerTypeGroup.style.display = 'block';
            } else {
                customInfluencerTypeGroup.style.display = 'none';
                document.getElementById('influencer_type_custom').value = '';
            }
        });
    }
});
</script>
@endsection