@extends('adminlte::page')

@section('title', 'Messages')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Messages</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Messages</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Message Threads</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($threads->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Subject</th>
                                            <th>Participants</th>
                                            <th>Last Message</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($threads as $thread)
                                            <tr>
                                                <td>
                                                    <a href="{{ route('creator.messages.show', $thread) }}">
                                                        {{ $thread->subject ?? 'No Subject' }}
                                                    </a>
                                                    @if(!$thread->isReadByUser(auth()->id()))
                                                        <span class="badge badge-primary">New</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @foreach($thread->participants as $participant)
                                                        @if($participant->user_id !== auth()->id())
                                                            {{ $participant->user->name }}
                                                        @endif
                                                    @endforeach
                                                </td>
                                                <td>
                                                    @if($thread->latestMessage)
                                                        {{ $thread->latestMessage->created_at->format('M j, Y H:i') }}
                                                    @else
                                                        No messages yet
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('creator.messages.show', $thread) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $threads->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-envelope fa-3x text-muted mb-3"></i>
                                <h4>No messages yet</h4>
                                <p class="text-muted">
                                    You don't have any message threads yet.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection