@extends('adminlte::page')

@section('title', 'Marketplace')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Marketplace</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Marketplace</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Filter Panel -->
            <div class="col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Filters</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form id="filterForm" method="GET" action="{{ route('creator.marketplace.index') }}">
                            <div class="form-group">
                                <label for="industries">Industry</label>
                                <select name="industries[]" id="industries" class="form-control select2" multiple>
                                    <option value="Technology">Technology</option>
                                    <option value="Fashion">Fashion</option>
                                    <option value="Food & Beverage">Food & Beverage</option>
                                    <option value="Travel">Travel</option>
                                    <option value="Health & Fitness">Health & Fitness</option>
                                    <option value="Beauty">Beauty</option>
                                    <option value="Entertainment">Entertainment</option>
                                </select>
                                <small class="form-text text-muted">Select one or more industries</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="followers">Followers</label>
                                <select name="followers" id="followers" class="form-control">
                                    <option value="">Any</option>
                                    <option value="1000-10000">1K - 10K</option>
                                    <option value="10000-100000">10K - 100K</option>
                                    <option value="100000-1000000">100K - 1M</option>
                                    <option value="1000000+">1M+</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary" id="applyFilters">
                                    <i class="fas fa-filter"></i> Apply Filters
                                </button>
                                <a href="{{ route('creator.marketplace.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Clear
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Brands List -->
            <div class="col-lg-9">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Brands</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($brands->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Brand</th>
                                            <th>Industry</th>
                                            <th>Total Followers</th>
                                            <th>Total Posts</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($brands as $brand)
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        @if($brand->logo_url)
                                                            <img src="{{ $brand->logo_url }}" alt="Logo" class="img-circle mr-2" style="width: 40px; height: 40px; object-fit: cover;">
                                                        @else
                                                            <div class="bg-light border rounded-circle mr-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                                <i class="fas fa-building text-muted"></i>
                                                            </div>
                                                        @endif
                                                        <div>
                                                            <div class="font-weight-bold">{{ $brand->name }}</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>{{ $brand->industry ?? 'Not specified' }}</td>
                                                @php
                                                    $followers = $brand->socialAggregates->firstWhere('key', 'total_followers');
                                                    $posts = $brand->socialAggregates->firstWhere('key', 'total_posts');
                                                @endphp
                                                <td>{{ number_format($followers ? $followers->getNumericValue() : 0) }}</td>
                                                <td>{{ number_format($posts ? $posts->getNumericValue() : 0) }}</td>
                                                <td>
                                                    <a href="#" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $brands->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-building fa-3x text-muted mb-3"></i>
                                <h4>No brands found</h4>
                                <p class="text-muted">
                                    There are no brands available at the moment.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2 for multi-select
    if ($.fn.select2) {
        $('#industries').select2({
            placeholder: 'Select industries',
            allowClear: true
        });
    }
    
    // Handle form submission with loading indicator
    $('#filterForm').on('submit', function() {
        $('#applyFilters').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Applying...');
    });
});
</script>
@endsection