@extends('adminlte::page')

@section('title', 'My Content')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">My Content</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Content</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row mb-3">
            <div class="col-12">
                <a href="{{ route('creator.content.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create New Content
                </a>
            </div>
        </div>

        <!-- Status Filter -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="btn-group" role="group">
                    <a href="{{ route('creator.content.index') }}" class="btn {{ request('status') ? 'btn-secondary' : 'btn-primary' }}">All</a>
                    <a href="{{ route('creator.content.index', ['status' => 'draft']) }}" class="btn {{ request('status') === 'draft' ? 'btn-primary' : 'btn-secondary' }}">Draft</a>
                    <a href="{{ route('creator.content.index', ['status' => 'pending']) }}" class="btn {{ request('status') === 'pending' ? 'btn-primary' : 'btn-secondary' }}">Pending</a>
                    <a href="{{ route('creator.content.index', ['status' => 'published']) }}" class="btn {{ request('status') === 'published' ? 'btn-primary' : 'btn-secondary' }}">Published</a>
                </div>
            </div>
        </div>

        <!-- Content List -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-0">
                        @if($contents->isEmpty())
                            <div class="p-4 text-center">
                                <p class="text-muted">No content found.</p>
                                <a href="{{ route('creator.content.create') }}" class="btn btn-primary">
                                    Create Your First Content
                                </a>
                            </div>
                        @else
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                            <th>Status</th>
                                            <th>Created At</th>
                                            <th class="text-right">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($contents as $content)
                                            <tr>
                                                <td>{{ $content->title }}</td>
                                                <td>
                                                    <span class="badge
                                                        @if($content->status === 'draft') badge-warning
                                                        @elseif($content->status === 'pending') badge-info
                                                        @elseif($content->status === 'published') badge-success
                                                        @endif">
                                                        {{ ucfirst($content->status) }}
                                                    </span>
                                                </td>
                                                <td>{{ $content->created_at->format('M d, Y') }}</td>
                                                <td class="text-right">
                                                    <a href="{{ route('creator.content.show', $content) }}" class="btn btn-info btn-sm">View</a>
                                                    <a href="{{ route('creator.content.edit', $content) }}" class="btn btn-primary btn-sm">Edit</a>
                                                    <form action="{{ route('creator.content.destroy', $content) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this content?')">Delete</button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection