@extends('adminlte::page')

@section('title', 'Generate Content Ideas')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Generate Content Ideas</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.content-ideas.index') }}">Content Ideas</a></li>
                    <li class="breadcrumb-item active">Generate</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Content Idea Parameters</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('creator.content-ideas.store') }}" method="POST">
                            @csrf
                            
                            <div class="form-group">
                                <label for="topic">Topic/Niche</label>
                                <input type="text" class="form-control" id="topic" name="topic" 
                                       placeholder="Enter your niche or content topic" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="platform">Platform</label>
                                <select class="form-control" id="platform" name="platform" required>
                                    <option value="">Select a platform</option>
                                    @if(!empty($platforms))
                                        @foreach($platforms as $platform)
                                        <option value="{{ $platform }}">{{ ucfirst($platform) }}</option>
                                        @endforeach
                                    @else
                                        <option value="instagram">Instagram</option>
                                        <option value="facebook">Facebook</option>
                                        <option value="twitter">Twitter</option>
                                        <option value="linkedin">LinkedIn</option>
                                        <option value="tiktok">TikTok</option>
                                        <option value="youtube">YouTube</option>
                                    @endif
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="style">Style Preference</label>
                                <select class="form-control" id="style" name="style" required>
                                    <option value="">Select a style</option>
                                    <option value="casual">Casual</option>
                                    <option value="trendy">Trendy</option>
                                    <option value="professional">Professional</option>
                                    <option value="humorous">Humorous</option>
                                    <option value="inspirational">Inspirational</option>
                                    <option value="educational">Educational</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="target_audience">Target Audience</label>
                                <input type="text" class="form-control" id="target_audience" name="target_audience" 
                                       placeholder="e.g., Young Adults, Professionals, etc." required>
                            </div>
                            
                            <div class="form-group">
                                <label for="number_of_ideas">Number of Ideas</label>
                                <input type="number" class="form-control" id="number_of_ideas" name="number_of_ideas" 
                                       min="1" max="20" value="5" required>
                                <small class="form-text text-muted">Generate between 1 and 20 content ideas</small>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Generate Content Ideas</button>
                            <a href="{{ route('creator.content-ideas.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">How It Works</h3>
                    </div>
                    <div class="card-body">
                        <p>Fill in the parameters to generate content ideas that are specific to your niche and audience.</p>
                        <ul>
                            <li><strong>Topic/Niche</strong>: Your main content focus area</li>
                            <li><strong>Platform</strong>: Where you plan to post the content</li>
                            <li><strong>Style Preference</strong>: The tone and style you prefer</li>
                            <li><strong>Target Audience</strong>: Who you're trying to reach</li>
                            <li><strong>Number of Ideas</strong>: How many ideas to generate</li>
                        </ul>
                        <p>Once generated, you can:</p>
                        <ul>
                            <li>Save ideas as favorites for later use</li>
                            <li>Copy ideas to your clipboard</li>
                            <li>Save ideas to draft for later use</li>
                            <li>Export ideas to brand proposals (if connected with a brand)</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection