@extends('layouts.app')

@section('title', 'Auto-Replies - Approved Suggestions')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Approved Auto-Replies</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.auto-replies.index') }}">Auto-Replies</a></li>
                    <li class="breadcrumb-item active">Approved</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Approved Auto-Reply Suggestions</h3>
                        <div class="card-tools">
                            <a href="{{ route('creator.auto-replies.settings') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <a href="{{ route('creator.auto-replies.index') }}" class="btn btn-info btn-sm">
                                <i class="fas fa-inbox"></i> Pending
                            </a>
                            <a href="{{ route('creator.auto-replies.posted') }}" class="btn btn-success btn-sm">
                                <i class="fas fa-paper-plane"></i> Posted
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($approvedSuggestions->isEmpty())
                            <div class="alert alert-info">
                                <h5><i class="icon fas fa-info"></i> No approved suggestions</h5>
                                There are currently no approved auto-reply suggestions. Approve pending suggestions to see them here.
                            </div>
                        @else
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Post</th>
                                            <th>Comment</th>
                                            <th>Approved Reply</th>
                                            <th>Confidence</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($approvedSuggestions as $suggestion)
                                            <tr>
                                                <td>
                                                    <div>
                                                        <strong>{{ $suggestion->socialComment->socialPost->title ?? 'Untitled Post' }}</strong>
                                                    </div>
                                                    <div class="text-muted">
                                                        <small>
                                                            {{ $suggestion->socialComment->socialAccount->provider }} - 
                                                            {{ $suggestion->socialComment->socialAccount->meta['name'] ?? 'Unknown Account' }}
                                                        </small>
                                                    </div>
                                                    <div class="text-muted">
                                                        <small>{{ $suggestion->socialComment->published_at->format('M j, Y H:i') }}</small>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-start">
                                                        <img src="{{ $suggestion->socialComment->author_avatar_url ?? asset('vendor/adminlte/dist/img/user2-160x160.jpg') }}" 
                                                             alt="{{ $suggestion->socialComment->author_name }}" 
                                                             class="img-circle mr-2" width="30" height="30">
                                                        <div>
                                                            <strong>{{ $suggestion->socialComment->author_name }}</strong>
                                                            @if($suggestion->socialComment->author_username)
                                                                <small class="text-muted">({{ $suggestion->socialComment->author_username }})</small>
                                                            @endif
                                                            <div>{{ $suggestion->socialComment->content }}</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="suggested-reply">{{ $suggestion->suggested_reply }}</div>
                                                    <div class="text-muted">
                                                        <small>Tone: {{ ucfirst($suggestion->preferred_tone ?? 'casual') }}</small>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="progress">
                                                        <div class="progress-bar 
                                                            @if($suggestion->confidence_score >= 90) bg-success 
                                                            @elseif($suggestion->confidence_score >= 70) bg-warning 
                                                            @else bg-danger 
                                                            @endif" 
                                                            role="progressbar" 
                                                            style="width: {{ $suggestion->confidence_score }}%" 
                                                            aria-valuenow="{{ $suggestion->confidence_score }}" 
                                                            aria-valuemin="0" 
                                                            aria-valuemax="100">
                                                            {{ $suggestion->confidence_score }}%
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <form action="{{ route('creator.auto-replies.post', $suggestion->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-success btn-sm" title="Post Reply">
                                                            <i class="fas fa-paper-plane"></i>
                                                        </button>
                                                    </form>
                                                    <button type="button" class="btn btn-primary btn-sm" 
                                                            data-toggle="modal" 
                                                            data-target="#editModal{{ $suggestion->id }}" 
                                                            title="Edit Reply">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <form action="{{ route('creator.auto-replies.skip', $suggestion->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-secondary btn-sm" title="Skip">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </form>
                                                    <form action="{{ route('creator.auto-replies.favorite', $suggestion->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-warning btn-sm" title="{{ $suggestion->is_favorite ? 'Remove from Favorites' : 'Add to Favorites' }}">
                                                            <i class="fas fa-star{{ $suggestion->is_favorite ? '' : '-o' }}"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                            
                                            <!-- Edit Modal -->
                                            <div class="modal fade" id="editModal{{ $suggestion->id }}" tabindex="-1" role="dialog">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <form action="{{ route('creator.auto-replies.edit', $suggestion->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Edit Auto-Reply</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="suggested_reply_{{ $suggestion->id }}">Reply Content</label>
                                                                    <textarea class="form-control" 
                                                                              id="suggested_reply_{{ $suggestion->id }}" 
                                                                              name="suggested_reply" 
                                                                              rows="3" 
                                                                              required>{{ $suggestion->suggested_reply }}</textarea>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label>Original Comment</label>
                                                                    <div class="border p-2 bg-light">
                                                                        <strong>{{ $suggestion->socialComment->author_name }}:</strong>
                                                                        {{ $suggestion->socialComment->content }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                                <button type="submit" class="btn btn-primary">Save Changes</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="d-flex justify-content-center">
                                {{ $approvedSuggestions->links() }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize modals
        $('.modal').on('shown.bs.modal', function () {
            $(this).find('textarea').focus();
        });
    });
</script>
@endsection