<section id="testimonials" class="py-20 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-bold text-gray-900 mb-4">
                Loved by Brands, Creators & Agencies
            </h2>
            <p class="text-xl text-gray-600">
                See what our customers have to say about their experience
            </p>
        </div>

        <!-- Testimonials Grid -->
        <div class="grid md:grid-cols-3 gap-8 mb-16">
            <!-- Testimonial 1 - Brand -->
            <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-shadow">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-bold text-xl">
                        M
                    </div>
                    <div class="ml-4">
                        <div class="font-semibold text-gray-900">Mark Thompson</div>
                        <div class="text-sm text-gray-500">Marketing Head, TechBrand</div>
                    </div>
                </div>
                <div class="flex mb-4">
                    @for($i = 0; $i < 5; $i++)
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                    @endfor
                </div>
                <p class="text-gray-600 italic">
                    "AI Business Market cut our campaign planning time by 70%. The AI proposal generator is a game-changer. We've increased our creator partnerships by 3x in just 2 months."
                </p>
                <div class="mt-4 pt-4 border-t border-gray-200">
                    <div class="text-sm text-gray-500">Results:</div>
                    <div class="text-2xl font-bold text-green-600">+200% ROI</div>
                </div>
            </div>

            <!-- Testimonial 2 - Creator -->
            <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-shadow">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center text-purple-600 font-bold text-xl">
                        N
                    </div>
                    <div class="ml-4">
                        <div class="font-semibold text-gray-900">Neha Sharma</div>
                        <div class="text-sm text-gray-500">Content Creator, 500K followers</div>
                    </div>
                </div>
                <div class="flex mb-4">
                    @for($i = 0; $i < 5; $i++)
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                    @endfor
                </div>
                <p class="text-gray-600 italic">
                    "The content ideas feature is incredible! I went from posting 3 times a week to daily posts. My engagement doubled and I landed 5 new brand deals in one month."
                </p>
                <div class="mt-4 pt-4 border-t border-gray-200">
                    <div class="text-sm text-gray-500">Results:</div>
                    <div class="text-2xl font-bold text-green-600">+120% Engagement</div>
                </div>
            </div>

            <!-- Testimonial 3 - Agency -->
            <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-shadow">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center text-green-600 font-bold text-xl">
                        R
                    </div>
                    <div class="ml-4">
                        <div class="font-semibold text-gray-900">Raj Patel</div>
                        <div class="text-sm text-gray-500">CEO, Digital Growth Agency</div>
                    </div>
                </div>
                <div class="flex mb-4">
                    @for($i = 0; $i < 5; $i++)
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                    @endfor
                </div>
                <p class="text-gray-600 italic">
                    "We manage 15 brands now vs 3 before. The white-label feature and multi-brand dashboard let us scale without hiring more staff. Client retention is up 40%."
                </p>
                <div class="mt-4 pt-4 border-t border-gray-200">
                    <div class="text-sm text-gray-500">Results:</div>
                    <div class="text-2xl font-bold text-green-600">5x Client Growth</div>
                </div>
            </div>
        </div>

        <!-- Video Testimonial (Optional) -->
        <div class="max-w-4xl mx-auto">
            <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                <div class="aspect-video bg-gray-900 flex items-center justify-center">
                    <button class="w-20 h-20 rounded-full bg-white/20 backdrop-blur-sm flex items-center justify-center hover:bg-white/30 transition">
                        <svg class="w-10 h-10 text-white ml-1" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M6.3 2.841A1.5 1.5 0 004 4.11V15.89a1.5 1.5 0 002.3 1.269l9.344-5.89a1.5 1.5 0 000-2.538L6.3 2.84z"/>
                        </svg>
                    </button>
                </div>
                <div class="p-6 text-center">
                    <p class="text-gray-600">Watch how Sarah from BeautyBrand increased her ROI by 300%</p>
                </div>
            </div>
        </div>
    </div>
</section>