@props(['plan' => null])

<div x-data="{ 
        show: false, 
        selectedPlan: @js($plan),
        init() {
            window.addEventListener('scroll', () => {
                this.show = window.scrollY > 800;
            });
        }
     }" 
     x-show="show"
     x-cloak
     x-transition:enter="transition ease-out duration-300"
     x-transition:enter-start="translate-y-full"
     x-transition:enter-end="translate-y-0"
     x-transition:leave="transition ease-in duration-200"
     x-transition:leave-start="translate-y-0"
     x-transition:leave-end="translate-y-full"
     class="fixed bottom-0 left-0 right-0 z-50 bg-white border-t-2 border-blue-600 shadow-2xl">
    
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
        <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
            <!-- Plan Info -->
            <div class="text-center sm:text-left">
                <div class="text-sm text-gray-600">Selected Plan:</div>
                <div class="flex items-baseline space-x-2">
                    <span class="text-xl font-bold text-gray-900" x-text="selectedPlan?.name || 'Pro'"></span>
                    <span class="text-lg text-gray-600" x-text="selectedPlan?.formatted_price || '₹999'"></span>
                    <span class="text-sm text-gray-500">/month</span>
                </div>
            </div>

            <!-- CTA Buttons -->
            <div class="flex items-center space-x-4">
                <a href="{{ route('marketing.pricing') }}" 
                   class="text-blue-600 font-semibold hover:text-blue-700 transition hidden sm:block">
                    Compare Plans
                </a>
                <a href="{{ route('register') }}" 
                   onclick="gtag('event', 'click', {'event_category': 'Sticky CTA', 'event_label': 'Start Trial'});"
                   class="bg-blue-600 text-white px-6 sm:px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition transform hover:scale-105 shadow-lg">
                    Start Free Trial
                </a>
            </div>
        </div>
    </div>
</div>