@props(['plan'])

<div x-data="{ open: false }" @keydown.escape.window="open = false">
    <!-- Trigger Button -->
    <button @click="open = true" {{ $attributes->merge(['class' => 'inline-block bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-200 transform hover:scale-105']) }}>
        {{ $slot }}
    </button>

    <!-- Modal Overlay -->
    <div x-show="open" 
         x-cloak
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 z-50 overflow-y-auto"
         aria-labelledby="modal-title" 
         role="dialog" 
         aria-modal="true">
        
        <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
            <!-- Background overlay -->
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" 
                 @click="open = false"
                 aria-hidden="true"></div>

            <!-- Center modal -->
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <!-- Modal Content -->
            <div x-show="open"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                 x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                 x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                 class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                
                <!-- Close Button -->
                <button @click="open = false" 
                        class="absolute top-4 right-4 text-gray-400 hover:text-gray-600 transition">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>

                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <!-- Header -->
                    <div class="text-center mb-6">
                        <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-blue-100 mb-4">
                            <svg class="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-2" id="modal-title">
                            Confirm Your Selection
                        </h3>
                        <p class="text-gray-600">
                            You're about to subscribe to the {{ $plan->name }} plan
                        </p>
                    </div>

                    <!-- Plan Summary -->
                    <div class="bg-gray-50 rounded-lg p-4 mb-6">
                        <div class="flex justify-between items-center mb-3">
                            <span class="text-lg font-semibold text-gray-900">{{ $plan->name }}</span>
                            <span class="text-2xl font-bold text-blue-600">{{ $plan->formatted_price }}</span>
                        </div>
                        
                        @if($plan->hasTrial())
                            <div class="bg-green-50 border border-green-200 rounded p-3 mb-3">
                                <p class="text-sm text-green-800 font-medium">
                                    🎉 {{ $plan->trial_days }}-day free trial included
                                </p>
                                <p class="text-xs text-green-700 mt-1">
                                    You won't be charged until {{ now()->addDays($plan->trial_days)->format('M d, Y') }}
                                </p>
                            </div>
                        @endif

                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Billing Cycle:</span>
                                <span class="font-medium">{{ ucfirst($plan->interval) }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Next Billing:</span>
                                <span class="font-medium">{{ now()->addDays($plan->hasTrial() ? $plan->trial_days : 30)->format('M d, Y') }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Key Features -->
                    <div class="mb-6">
                        <h4 class="font-semibold text-gray-900 mb-3">What's Included:</h4>
                        <ul class="space-y-2">
                            @foreach(array_slice($plan->features, 0, 4) as $feature)
                                <li class="flex items-start text-sm">
                                    <svg class="w-4 h-4 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">{{ $feature }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    <!-- Terms -->
                    <div class="text-xs text-gray-500 mb-4">
                        By proceeding, you agree to our 
                        <a href="#" class="text-blue-600 hover:text-blue-700 underline">Terms of Service</a> and 
                        <a href="#" class="text-blue-600 hover:text-blue-700 underline">Privacy Policy</a>. 
                        You can cancel anytime.
                    </div>
                </div>

                <!-- Footer Actions -->
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse gap-3">
                    <a href="{{ route('subscription.checkout', $plan) }}" 
                       onclick="gtag('event', 'checkout_initiated', {'plan_id': '{{ $plan->id }}', 'plan_name': '{{ $plan->name }}', 'amount': {{ $plan->price }}});"
                       class="w-full inline-flex justify-center rounded-lg border border-transparent shadow-sm px-6 py-3 bg-blue-600 text-base font-semibold text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:w-auto transition">
                        Proceed to Payment
                    </a>
                    <button type="button" 
                            @click="open = false"
                            class="mt-3 w-full inline-flex justify-center rounded-lg border border-gray-300 shadow-sm px-6 py-3 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:mt-0 sm:w-auto transition">
                        Cancel
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>