@extends('adminlte::page')

@section('title', 'Proposals')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Proposals</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Proposals</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Your Proposals</h3>
                        <div class="card-tools">
                            <a href="{{ route('brand.proposals.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Create New Proposal
                            </a>
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($proposals->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                            <th>Creator</th>
                                            <th>Type</th>
                                            <th>Budget</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($proposals as $proposal)
                                            <tr>
                                                <td>{{ $proposal->title }}</td>
                                                <td>{{ $proposal->creator->name }}</td>
                                                <td>{{ $proposal->type }}</td>
                                                <td>{{ $proposal->budget ? '$' . number_format($proposal->budget, 2) : 'N/A' }}</td>
                                                <td>
                                                    @switch($proposal->status)
                                                        @case('sent')
                                                            <span class="badge badge-warning">Sent</span>
                                                            @break
                                                        @case('accepted')
                                                            <span class="badge badge-success">Accepted</span>
                                                            @break
                                                        @case('rejected')
                                                            <span class="badge badge-danger">Rejected</span>
                                                            @break
                                                        @default
                                                            <span class="badge badge-secondary">{{ ucfirst($proposal->status) }}</span>
                                                    @endswitch
                                                </td>
                                                <td>{{ $proposal->created_at->format('M j, Y') }}</td>
                                                <td>
                                                    <a href="{{ route('brand.proposals.show', $proposal) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                    @if($proposal->status === 'sent')
                                                        <button type="button" class="btn btn-success btn-sm" 
                                                                onclick="acceptProposal({{ $proposal->id }})">
                                                            <i class="fas fa-check"></i> Accept
                                                        </button>
                                                        <button type="button" class="btn btn-danger btn-sm" 
                                                                onclick="rejectProposal({{ $proposal->id }})">
                                                            <i class="fas fa-times"></i> Reject
                                                        </button>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $proposals->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-file-contract fa-3x text-muted mb-3"></i>
                                <h4>No proposals found</h4>
                                <p class="text-muted">
                                    You haven't sent any proposals yet.
                                </p>
                                <a href="{{ route('brand.proposals.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create Your First Proposal
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Accept proposal function
    window.acceptProposal = function(proposalId) {
        if (confirm('Are you sure you want to accept this proposal?')) {
            // This would make an AJAX call to accept the proposal
            alert('Accept proposal functionality would be implemented here');
        }
    };
    
    // Reject proposal function
    window.rejectProposal = function(proposalId) {
        if (confirm('Are you sure you want to reject this proposal?')) {
            // This would make an AJAX call to reject the proposal
            alert('Reject proposal functionality would be implemented here');
        }
    };
});
</script>
@endsection