@extends('adminlte::page')

@section('title', 'Recommended Creators')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Recommended Creators</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.marketplace.index') }}">Marketplace</a></li>
                    <li class="breadcrumb-item active">Recommendations</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Recommended for You</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($creators->count() > 0)
                            <div class="row">
                                @foreach($creators as $creator)
                                    <div class="col-md-6 col-lg-4 mb-4">
                                        <div class="card h-100">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center mb-3">
                                                    @if($creator->avatar_url)
                                                        <img src="{{ $creator->avatar_url }}" alt="Avatar" class="img-circle mr-2" style="width: 50px; height: 50px; object-fit: cover;">
                                                    @else
                                                        <div class="bg-light border rounded-circle mr-2 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                                            <i class="fas fa-user text-muted"></i>
                                                        </div>
                                                    @endif
                                                    <div>
                                                        <h5 class="card-title mb-0">{{ $creator->name }}</h5>
                                                        <small class="text-muted">
                                                            @if($creator->influencer_type === 'Other' && $creator->influencer_type_custom)
                                                                {{ $creator->influencer_type_custom }}
                                                            @else
                                                                {{ $creator->influencer_type ?? 'Not specified' }}
                                                            @endif
                                                        </small>
                                                    </div>
                                                </div>
                                                
                                                @php
                                                    $followers = $creator->socialAggregates->firstWhere('key', 'total_followers');
                                                    $posts = $creator->socialAggregates->firstWhere('key', 'total_posts');
                                                    $engagement = $creator->socialAggregates->firstWhere('key', 'engagement_rate');
                                                @endphp
                                                
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <small class="text-muted">Followers</small>
                                                        <div class="font-weight-bold">{{ number_format($followers ? $followers->getNumericValue() : 0) }}</div>
                                                    </div>
                                                    <div>
                                                        <small class="text-muted">Posts</small>
                                                        <div class="font-weight-bold">{{ number_format($posts ? $posts->getNumericValue() : 0) }}</div>
                                                    </div>
                                                    <div>
                                                        <small class="text-muted">Engagement</small>
                                                        <div class="font-weight-bold">{{ number_format($engagement ? $engagement->getNumericValue() : 0, 2) }}%</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer">
                                                <a href="{{ route('brand.creators.show', $creator) }}" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-eye"></i> View Profile
                                                </a>
                                                <button type="button" class="btn btn-success btn-sm" 
                                                        onclick="sendProposal({{ $creator->id }})">
                                                    <i class="fas fa-paper-plane"></i> Send Proposal
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-star fa-3x text-muted mb-3"></i>
                                <h4>No recommendations found</h4>
                                <p class="text-muted">
                                    We couldn't find any recommendations for you at the moment.
                                </p>
                                <a href="{{ route('brand.marketplace.index') }}" class="btn btn-primary">
                                    <i class="fas fa-search"></i> Browse Creators
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Send proposal function
    window.sendProposal = function(creatorId) {
        // Redirect to proposal creation page
        window.location.href = `/brand/creators/${creatorId}/proposal/create`;
    };
});
</script>
@endsection