@extends('adminlte::page')

@section('title', 'Creator Profile')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Creator Profile</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.creators.index') }}">Creators</a></li>
                    <li class="breadcrumb-item active">{{ $creator->name }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Creator Information</h3>
                    </div>
                    <div class="card-body text-center">
                        @if($creator->avatar_url)
                            <img src="{{ $creator->avatar_url }}" alt="Avatar" class="img-circle mb-3" style="width: 150px; height: 150px; object-fit: cover;">
                        @else
                            <div class="bg-light border rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" style="width: 150px; height: 150px;">
                                <i class="fas fa-user fa-3x text-muted"></i>
                            </div>
                        @endif
                        
                        <h3>{{ $creator->name }}</h3>
                        <p class="text-muted">{{ $creator->email }}</p>
                        
                        @if($creator->influencer_type)
                            <p>
                                <strong>Influencer Type:</strong>
                                @if($creator->influencer_type === 'Other' && $creator->influencer_type_custom)
                                    <span class="badge badge-info">{{ $creator->influencer_type_custom }}</span>
                                @else
                                    <span class="badge badge-info">{{ $creator->influencer_type }}</span>
                                @endif
                            </p>
                        @endif
                        
                        @if($creator->bio)
                            <p class="mt-3">{{ $creator->bio }}</p>
                        @endif
                    </div>
                </div>
                
                <!-- KPI Cards -->
                <div class="row">
                    <div class="col-12">
                        @php
                            $followers = $creator->socialAggregates->firstWhere('key', 'total_followers');
                            $posts = $creator->socialAggregates->firstWhere('key', 'total_posts');
                            $views = $creator->socialAggregates->firstWhere('key', 'total_views');
                            $engagement = $creator->socialAggregates->firstWhere('key', 'engagement_rate');
                        @endphp
                        
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h3>{{ number_format($followers ? $followers->getNumericValue() : 0) }}</h3>
                                <p>Total Followers</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-users"></i>
                            </div>
                        </div>
                        
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3>{{ number_format($posts ? $posts->getNumericValue() : 0) }}</h3>
                                <p>Total Posts</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-file-alt"></i>
                            </div>
                        </div>
                        
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h3>{{ number_format($views ? $views->getNumericValue() : 0) }}</h3>
                                <p>Total Views</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-eye"></i>
                            </div>
                        </div>
                        
                        <div class="small-box bg-danger">
                            <div class="inner">
                                <h3>{{ number_format($engagement ? $engagement->getNumericValue() : 0, 2) }}%</h3>
                                <p>Engagement Rate</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-heart"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-8">
                <!-- Connection Status -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Connection Status</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        @if($connections->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Platform</th>
                                            <th>Account</th>
                                            <th>Followers</th>
                                            <th>Connected At</th>
                                            <th>Last Synced</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($connections as $connection)
                                        <tr>
                                            <td>
                                                <i class="fab fa-{{ $connection->provider }} mr-1"></i>
                                                {{ ucfirst($connection->provider) }}
                                            </td>
                                            <td>
                                                @if($connection->is_demo)
                                                <span class="badge badge-warning">Demo Account</span>
                                                @else
                                                {{ $connection->meta['username'] ?? $connection->meta['name'] ?? $connection->provider_user_id }}
                                                @endif
                                            </td>
                                            <td>{{ number_format($connection->meta['followers'] ?? 0) }}</td>
                                            <td>{{ $connection->connected_at ? $connection->connected_at->format('M j, Y H:i') : 'N/A' }}</td>
                                            <td>{{ $connection->last_synced_at ? $connection->last_synced_at->format('M j, Y H:i') : 'Never' }}</td>
                                            <td>
                                                @if($connection->is_demo)
                                                <span class="badge badge-warning">Demo</span>
                                                @elseif($connection->isTokenExpired())
                                                <span class="badge badge-danger">Token Expired</span>
                                                @else
                                                <span class="badge badge-success">Active</span>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="p-3 text-center">
                                <p class="text-muted">No social accounts connected yet.</p>
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Recent Posts Grid -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Recent Posts/Videos</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($recentActivity->count() > 0)
                            <div class="row">
                                @foreach($recentActivity as $post)
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <div class="d-flex">
                                                <div class="flex-shrink-0">
                                                    @if(!empty($post->media['thumbnail']))
                                                        <img src="{{ $post->media['thumbnail'] }}" alt="Thumbnail" class="img-fluid rounded" style="width: 80px; height: 60px; object-fit: cover;">
                                                    @else
                                                        <div class="bg-light border text-center d-flex align-items-center justify-content-center" style="width: 80px; height: 60px;">
                                                            <i class="fas fa-image text-muted"></i>
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h6 class="card-title mb-1">{{ Str::limit($post->title ?? $post->caption ?? 'No title', 30) }}</h6>
                                                    <small class="text-muted">{{ ucfirst($post->socialAccount->provider) }}</small>
                                                </div>
                                            </div>
                                            
                                            <div class="mt-2">
                                                <span class="badge badge-primary">{{ number_format($post->getViewsCount()) }} views</span>
                                                <span class="badge badge-success">{{ number_format($post->getLikesCount()) }} likes</span>
                                                <span class="badge badge-warning">{{ number_format($post->getCommentsCount()) }} comments</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center p-3">
                                <p class="text-muted">No recent posts found.</p>
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Send Proposal Button -->
                <div class="card">
                    <div class="card-body text-center">
                        <a href="{{ route('brand.creators.proposal.create', $creator) }}" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane mr-2"></i>Send Proposal
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection