@extends('adminlte::page')

@section('title', 'Send Proposal')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Send Proposal to {{ $creator->name }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.creators.index') }}">Creators</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.creators.show', $creator) }}">Profile</a></li>
                    <li class="breadcrumb-item active">Send Proposal</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Proposal Details</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('brand.creators.proposal.store', $creator) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <div class="form-group">
                                <label for="title">Proposal Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required>
                                @error('title')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="message">Message <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('message') is-invalid @enderror" id="message" name="message" rows="6" required>{{ old('message') }}</textarea>
                                @error('message')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="type">Proposal Type <span class="text-danger">*</span></label>
                                <select class="form-control @error('type') is-invalid @enderror" id="type" name="type" required>
                                    <option value="">Select a type</option>
                                    <option value="Collaboration" {{ old('type') == 'Collaboration' ? 'selected' : '' }}>Collaboration</option>
                                    <option value="Sponsored Post" {{ old('type') == 'Sponsored Post' ? 'selected' : '' }}>Sponsored Post</option>
                                    <option value="Affiliate" {{ old('type') == 'Affiliate' ? 'selected' : '' }}>Affiliate</option>
                                    <option value="Long-term Partnership" {{ old('type') == 'Long-term Partnership' ? 'selected' : '' }}>Long-term Partnership</option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="budget">Estimated Budget</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control @error('budget') is-invalid @enderror" id="budget" name="budget" value="{{ old('budget') }}" step="0.01" min="0">
                                            <div class="input-group-append">
                                                <span class="input-group-text">$</span>
                                            </div>
                                        </div>
                                        @error('budget')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="duration">Duration</label>
                                        <input type="text" class="form-control @error('duration') is-invalid @enderror" id="duration" name="duration" value="{{ old('duration') }}" placeholder="e.g., 2 weeks, 1 month">
                                        @error('duration')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="deliverables">Deliverables</label>
                                <select multiple class="form-control @error('deliverables') is-invalid @enderror" id="deliverables" name="deliverables[]">
                                    <option value="1 Instagram post" {{ in_array('1 Instagram post', old('deliverables', [])) ? 'selected' : '' }}>1 Instagram post</option>
                                    <option value="2 Instagram reels" {{ in_array('2 Instagram reels', old('deliverables', [])) ? 'selected' : '' }}>2 Instagram reels</option>
                                    <option value="1 YouTube video" {{ in_array('1 YouTube video', old('deliverables', [])) ? 'selected' : '' }}>1 YouTube video</option>
                                    <option value="1 TikTok video" {{ in_array('1 TikTok video', old('deliverables', [])) ? 'selected' : '' }}>1 TikTok video</option>
                                    <option value="1 Blog post" {{ in_array('1 Blog post', old('deliverables', [])) ? 'selected' : '' }}>1 Blog post</option>
                                    <option value="3 Stories" {{ in_array('3 Stories', old('deliverables', [])) ? 'selected' : '' }}>3 Stories</option>
                                </select>
                                @error('deliverables')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="attachment">Attachment (PDF)</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                    <label class="custom-file-label" for="attachment">Choose file</label>
                                </div>
                                <small class="form-text text-muted">Maximum file size: 2MB. Only PDF files allowed.</small>
                                @error('attachment')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="visibility" name="visibility" checked>
                                    <label class="custom-control-label" for="visibility">Keep this proposal private to {{ $creator->name }}</label>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Send Proposal</button>
                            <a href="{{ route('brand.creators.show', $creator) }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Creator Information</h3>
                    </div>
                    <div class="card-body text-center">
                        @if($creator->avatar_url)
                            <img src="{{ $creator->avatar_url }}" alt="Avatar" class="img-circle mb-3" style="width: 100px; height: 100px; object-fit: cover;">
                        @else
                            <div class="bg-light border rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" style="width: 100px; height: 100px;">
                                <i class="fas fa-user fa-2x text-muted"></i>
                            </div>
                        @endif
                        
                        <h4>{{ $creator->name }}</h4>
                        <p class="text-muted">{{ $creator->email }}</p>
                        
                        @if($creator->influencer_type)
                            <p>
                                <strong>Influencer Type:</strong>
                                @if($creator->influencer_type === 'Other' && $creator->influencer_type_custom)
                                    <span class="badge badge-info">{{ $creator->influencer_type_custom }}</span>
                                @else
                                    <span class="badge badge-info">{{ $creator->influencer_type }}</span>
                                @endif
                            </p>
                        @endif
                    </div>
                </div>
                
                <!-- Summary KPIs -->
                @php
                    $followers = $creator->socialAggregates->firstWhere('key', 'total_followers');
                    $posts = $creator->socialAggregates->firstWhere('key', 'total_posts');
                    $views = $creator->socialAggregates->firstWhere('key', 'total_views');
                    $engagement = $creator->socialAggregates->firstWhere('key', 'engagement_rate');
                @endphp
                
                <div class="row">
                    <div class="col-12">
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h3>{{ number_format($followers ? $followers->getNumericValue() : 0) }}</h3>
                                <p>Total Followers</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-users"></i>
                            </div>
                        </div>
                        
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3>{{ number_format($posts ? $posts->getNumericValue() : 0) }}</h3>
                                <p>Total Posts</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-file-alt"></i>
                            </div>
                        </div>
                        
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h3>{{ number_format($views ? $views->getNumericValue() : 0) }}</h3>
                                <p>Total Views</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-eye"></i>
                            </div>
                        </div>
                        
                        <div class="small-box bg-danger">
                            <div class="inner">
                                <h3>{{ number_format($engagement ? $engagement->getNumericValue() : 0, 2) }}%</h3>
                                <p>Engagement Rate</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-heart"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Update file input label when file is selected
    document.getElementById('attachment').addEventListener('change', function(e) {
        var fileName = e.target.files[0] ? e.target.files[0].name : 'Choose file';
        var nextSibling = e.target.nextElementSibling;
        nextSibling.innerText = fileName;
    });
});
</script>
@endsection