@extends('adminlte::page')

@section('title', 'Campaigns')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Campaigns</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Campaigns</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Your Campaigns</h3>
                        <div class="card-tools">
                            <a href="{{ route('brand.campaigns.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Create New Campaign
                            </a>
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($campaigns->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Status</th>
                                            <th>Budget</th>
                                            <th>Creators</th>
                                            <th>Dates</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($campaigns as $campaign)
                                            <tr>
                                                <td>{{ $campaign->name }}</td>
                                                <td>
                                                    @switch($campaign->status)
                                                        @case('draft')
                                                            <span class="badge badge-secondary">Draft</span>
                                                            @break
                                                        @case('active')
                                                            <span class="badge badge-success">Active</span>
                                                            @break
                                                        @case('paused')
                                                            <span class="badge badge-warning">Paused</span>
                                                            @break
                                                        @case('completed')
                                                            <span class="badge badge-info">Completed</span>
                                                            @break
                                                        @case('cancelled')
                                                            <span class="badge badge-danger">Cancelled</span>
                                                            @break
                                                        @default
                                                            <span class="badge badge-secondary">{{ ucfirst($campaign->status) }}</span>
                                                    @endswitch
                                                </td>
                                                <td>
                                                    {{ $campaign->budget ? '$' . number_format($campaign->budget, 2) : 'N/A' }}
                                                    @if($campaign->encrypted_budget)
                                                        <span class="badge badge-success">E</span>
                                                    @endif
                                                </td>
                                                <td>{{ $campaign->creators_count }}</td>
                                                <td>
                                                    @if($campaign->start_date && $campaign->end_date)
                                                        {{ $campaign->start_date->format('M j') }} - {{ $campaign->end_date->format('M j, Y') }}
                                                    @else
                                                        N/A
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('brand.campaigns.show', $campaign) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                    @if(in_array($campaign->status, ['draft', 'active', 'paused']))
                                                        <button type="button" class="btn btn-info btn-sm" 
                                                                onclick="editCampaign({{ $campaign->id }})">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </button>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $campaigns->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-bullhorn fa-3x text-muted mb-3"></i>
                                <h4>No campaigns found</h4>
                                <p class="text-muted">
                                    You haven't created any campaigns yet.
                                </p>
                                <a href="{{ route('brand.campaigns.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create Your First Campaign
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Edit campaign function
    window.editCampaign = function(campaignId) {
        // Redirect to campaign edit page
        window.location.href = `/brand/campaigns/${campaignId}/edit`;
    };
});
</script>
@endsection