@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="px-4 py-6 sm:px-0">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-900">Agency Dashboard</h1>
        </div>

        <!-- Stats Section -->
        <div class="mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Overview</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex items-center">
                        <div class="text-3xl font-bold text-blue-600">{{ $totalCampaigns }}</div>
                        <div class="ml-4 text-gray-500">
                            <div class="text-lg font-medium">Total Campaigns</div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex items-center">
                        <div class="text-3xl font-bold text-green-600">{{ $activeCampaigns }}</div>
                        <div class="ml-4 text-gray-500">
                            <div class="text-lg font-medium">Active Campaigns</div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex items-center">
                        <div class="text-3xl font-bold text-purple-600">${{ number_format($totalBudget, 2) }}</div>
                        <div class="ml-4 text-gray-500">
                            <div class="text-lg font-medium">Total Budget</div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex items-center">
                        <div class="text-3xl font-bold text-yellow-600">{{ $linkedBrands }}</div>
                        <div class="ml-4 text-gray-500">
                            <div class="text-lg font-medium">Linked Brands</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Campaigns Section -->
        <div class="mb-8">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-semibold text-gray-800">Recent Campaigns</h2>
                <a href="{{ route('agency.campaigns.index') }}" class="text-blue-600 hover:text-blue-800">
                    View All Campaigns
                </a>
            </div>
            <div class="bg-white shadow overflow-hidden sm:rounded-md">
                <ul class="divide-y divide-gray-200">
                    @if($recentCampaigns->count() > 0)
                        @foreach($recentCampaigns as $campaign)
                            <li>
                                <div class="px-4 py-4 sm:px-6">
                                    <div class="flex items-center justify-between">
                                        <p class="text-sm font-medium text-blue-600 truncate">
                                            {{ $campaign->name }}
                                        </p>
                                        <div class="ml-2 flex-shrink-0 flex">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                                {{ $campaign->status }}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="mt-2 sm:flex sm:justify-between">
                                        <div class="sm:flex">
                                            <p class="flex items-center text-sm text-gray-500">
                                                Brand: {{ $campaign->brand->name }}
                                            </p>
                                        </div>
                                        <div class="mt-2 flex items-center text-sm text-gray-500 sm:mt-0">
                                            <p>
                                                Budget: ${{ number_format($campaign->budget, 2) }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    @else
                        <li>
                            <div class="px-4 py-5 sm:px-6">
                                <div class="flex justify-between">
                                    <p class="text-sm font-medium text-gray-500">No campaigns created yet</p>
                                </div>
                            </div>
                        </li>
                    @endif
                </ul>
            </div>
        </div>

        <!-- Linked Brands Section -->
        <div>
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-semibold text-gray-800">Linked Brands</h2>
                <a href="{{ route('agency.campaigns.create') }}" class="text-blue-600 hover:text-blue-800">
                    Create Campaign
                </a>
            </div>
            <div class="bg-white shadow overflow-hidden sm:rounded-md">
                <ul class="divide-y divide-gray-200">
                    @if($linkedBrands > 0)
                        @foreach(Auth::user()->brands as $brand)
                            <li>
                                <div class="px-4 py-4 sm:px-6">
                                    <div class="flex items-center justify-between">
                                        <p class="text-sm font-medium text-blue-600 truncate">
                                            {{ $brand->name }}
                                        </p>
                                    </div>
                                    <div class="mt-2 sm:flex sm:justify-between">
                                        <div class="sm:flex">
                                            <p class="flex items-center text-sm text-gray-500">
                                                {{ $brand->description ?? 'No description available' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    @else
                        <li>
                            <div class="px-4 py-5 sm:px-6">
                                <div class="flex justify-between">
                                    <p class="text-sm font-medium text-gray-500">No brands linked yet</p>
                                </div>
                            </div>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection