# Marketing Frontend - QA Checklist

## Pre-Deployment Quality Assurance Checklist

Use this checklist to ensure all marketing frontend components meet quality standards before deployment.

---

## ✅ Visual QA

### Desktop (≥1024px)
- [ ] Landing page matches design specifications
- [ ] Hero section displays correctly with animations
- [ ] Role cards are properly aligned
- [ ] Pricing cards display with correct spacing
- [ ] Feature comparison table is readable
- [ ] Footer links are organized correctly
- [ ] All images load without errors
- [ ] Typography is consistent across pages
- [ ] Color scheme matches brand guidelines
- [ ] Buttons have correct hover states

### Tablet (641-1024px)
- [ ] Navigation collapses appropriately
- [ ] Grid layouts adjust to 2 columns
- [ ] Images scale proportionally
- [ ] Text remains readable
- [ ] Touch targets are adequate (min 44x44px)

### Mobile (≤640px)
- [ ] Mobile menu works correctly
- [ ] Hero text is readable
- [ ] Pricing cards stack vertically
- [ ] Feature table becomes accordion
- [ ] Sticky CTA appears at bottom
- [ ] Forms are easy to fill
- [ ] All content is accessible without horizontal scroll

---

## ✅ Functional QA

### Navigation
- [ ] All header links work
- [ ] Mobile menu opens/closes
- [ ] Logo links to home page
- [ ] Active page is highlighted
- [ ] Dropdown menus work (if any)

### Landing Page
- [ ] Role selector changes content
- [ ] Hero CTAs link correctly
- [ ] Role cards navigate to onboarding
- [ ] Feature grid displays all features
- [ ] Testimonials carousel works
- [ ] FAQ accordion expands/collapses
- [ ] Sticky CTA appears on scroll

### Pricing Page
- [ ] Monthly/Yearly toggle updates prices
- [ ] Savings badge shows correct amount
- [ ] Role filter works correctly
- [ ] Plan CTAs open checkout modal
- [ ] Feature comparison table scrolls
- [ ] Mobile accordion expands
- [ ] "Most Popular" badge displays

### Checkout Flow
- [ ] Checkout modal opens correctly
- [ ] Plan details are accurate
- [ ] Razorpay modal triggers
- [ ] Payment processes successfully
- [ ] Success page displays after payment
- [ ] Invoice link works
- [ ] Error handling works for failed payments

### Demo Page
- [ ] Video player loads
- [ ] Play button works
- [ ] Feature tabs switch content
- [ ] Screenshots display correctly
- [ ] CTAs link to registration

### Help Center
- [ ] Search bar accepts input
- [ ] Category links work
- [ ] Articles are clickable
- [ ] FAQ section displays
- [ ] Contact support links work

### Onboarding
- [ ] Progress bar updates
- [ ] Step navigation works (Next/Back)
- [ ] Social account buttons are clickable
- [ ] Goal checkboxes work
- [ ] Final step links to dashboard
- [ ] Skip options work

### Subscription Management
- [ ] Current plan displays correctly
- [ ] Usage limits show accurate data
- [ ] Progress bars render correctly
- [ ] Upgrade/downgrade buttons work
- [ ] Cancel subscription flow works
- [ ] Resume subscription works
- [ ] Invoice list displays
- [ ] Download invoice works

---

## ✅ Performance QA

### Lighthouse Scores
- [ ] Performance: ≥ 80
- [ ] Accessibility: ≥ 90
- [ ] Best Practices: ≥ 90
- [ ] SEO: ≥ 90

### Load Times
- [ ] First Contentful Paint < 1.5s (desktop)
- [ ] Time to Interactive < 3s (mobile)
- [ ] Largest Contentful Paint < 2.5s
- [ ] Cumulative Layout Shift < 0.1

### Optimization
- [ ] Images are optimized (WebP/AVIF)
- [ ] Images have proper alt text
- [ ] Lazy loading works for below-fold images
- [ ] CSS is minified
- [ ] JavaScript is minified
- [ ] No unused CSS/JS
- [ ] Fonts are preloaded
- [ ] External resources use preconnect

---

## ✅ Accessibility QA

### Keyboard Navigation
- [ ] Tab order is logical
- [ ] All interactive elements are focusable
- [ ] Focus indicators are visible
- [ ] Skip to content link works
- [ ] Modal traps focus correctly
- [ ] Escape key closes modals
- [ ] Enter/Space activates buttons

### Screen Reader
- [ ] Page title is announced
- [ ] Headings are hierarchical (H1 → H2 → H3)
- [ ] Images have alt text
- [ ] Links have descriptive text
- [ ] Form labels are associated
- [ ] ARIA labels are present
- [ ] Dynamic content announces changes
- [ ] Error messages are announced

### Color & Contrast
- [ ] Text contrast ≥ 4.5:1 (normal text)
- [ ] Text contrast ≥ 3:1 (large text)
- [ ] Links are distinguishable
- [ ] Focus indicators are visible
- [ ] Color is not the only indicator

---

## ✅ Analytics QA

### Event Tracking
- [ ] Page views fire on all pages
- [ ] Pricing view event fires
- [ ] Plan click events fire with correct data
- [ ] Checkout initiated event fires
- [ ] Payment success event fires
- [ ] Trial started event fires
- [ ] CTA clicks are tracked
- [ ] Video play events fire
- [ ] Search events fire
- [ ] Scroll depth tracking works

### UTM Parameters
- [ ] UTM params are captured from URL
- [ ] UTM params persist in session
- [ ] UTM params included in checkout
- [ ] UTM params visible in analytics

### Google Analytics 4
- [ ] Events appear in GA4 real-time
- [ ] User properties are set
- [ ] E-commerce events track correctly
- [ ] Conversion tracking works

---

## ✅ SEO QA

### Meta Tags
- [ ] Title tags are unique per page
- [ ] Meta descriptions are unique
- [ ] Canonical URLs are set
- [ ] OpenGraph tags are present
- [ ] Twitter Card tags are present
- [ ] Viewport meta tag is set

### Structured Data
- [ ] Organization schema on home
- [ ] Product schema on pricing
- [ ] FAQ schema on help page
- [ ] Video schema on demo page
- [ ] No structured data errors (Google Rich Results Test)

### Content
- [ ] H1 tag is unique per page
- [ ] Heading hierarchy is correct
- [ ] Internal links use descriptive text
- [ ] Images have alt attributes
- [ ] No broken links (404s)

---

## ✅ Security QA

### Payment Security
- [ ] No card details handled in frontend
- [ ] Razorpay handles all payment data
- [ ] HTTPS enforced on checkout
- [ ] CSRF tokens present in forms
- [ ] No sensitive data in URLs

### Privacy & Compliance
- [ ] Cookie consent banner displays
- [ ] Privacy policy link is visible
- [ ] Terms of service link is visible
- [ ] GDPR compliance notice
- [ ] Data collection is transparent

---

## ✅ Cross-Browser QA

### Chrome
- [ ] All features work
- [ ] No console errors
- [ ] Animations smooth
- [ ] Layout correct

### Firefox
- [ ] All features work
- [ ] No console errors
- [ ] Animations smooth
- [ ] Layout correct

### Safari (Desktop)
- [ ] All features work
- [ ] No console errors
- [ ] Animations smooth
- [ ] Layout correct
- [ ] Webkit-specific styles work

### Safari (iOS)
- [ ] Touch interactions work
- [ ] Modals display correctly
- [ ] Forms are usable
- [ ] No layout issues

### Edge
- [ ] All features work
- [ ] No console errors
- [ ] Layout correct

---

## ✅ Integration QA

### Razorpay
- [ ] Test mode works
- [ ] Live mode configured
- [ ] Webhook receives events
- [ ] Payment verification works
- [ ] Refunds process correctly

### Email
- [ ] Welcome email sends
- [ ] Receipt email sends
- [ ] Subscription confirmation sends
- [ ] Cancellation email sends

### Database
- [ ] Subscriptions are created
- [ ] Invoices are generated
- [ ] User roles are assigned
- [ ] Analytics events are logged

---

## ✅ Content QA

### Copy
- [ ] No spelling errors
- [ ] Grammar is correct
- [ ] Tone is consistent
- [ ] CTAs are action-oriented
- [ ] Benefits are clear
- [ ] No placeholder text remains

### Legal
- [ ] Privacy policy is up to date
- [ ] Terms of service are current
- [ ] Cookie policy is accurate
- [ ] Refund policy is clear

---

## ✅ Final Checks

- [ ] All TODO comments removed
- [ ] Console.log statements removed
- [ ] Debug mode disabled
- [ ] Error pages work (404, 500)
- [ ] Maintenance mode tested
- [ ] Backup created before deployment
- [ ] Rollback plan documented
- [ ] Team notified of deployment

---

## Sign-Off

| Role | Name | Date | Signature |
|------|------|------|-----------|
| Frontend Developer | | | |
| QA Engineer | | | |
| Product Manager | | | |
| Marketing Lead | | | |

---

**Checklist Version**: 1.0  
**Last Updated**: 2024-01-15