# Provider Credentials Configuration Guide

## Overview

This feature allows Brand Admins to configure API credentials for social media and advertising platforms directly from the application settings, enabling self-managed ads, posting, and analytics without developer intervention.

## Table of Contents

1. [Supported Providers](#supported-providers)
2. [Setup Instructions](#setup-instructions)
3. [API Endpoints](#api-endpoints)
4. [Security Features](#security-features)
5. [Token Management](#token-management)
6. [Troubleshooting](#troubleshooting)

---

## Supported Providers

### Social Media Platforms
- **YouTube** - Video content and analytics
- **Instagram** - Posts, stories, and insights
- **TikTok** - Video content and metrics
- **LinkedIn** - Professional content sharing
- **X (Twitter)** - Tweets and engagement

### Advertising Platforms
- **Facebook Ads** - Ad campaign management
- **Google Ads** - Search and display advertising
- **Custom Provider** - For proprietary or other platforms

---

## Setup Instructions

### For Brand Admins

#### 1. Access Integration Settings
Navigate to: **Settings → Integrations → Add Provider**

#### 2. Select Provider
Choose from the list of supported providers based on your needs.

#### 3. Configure Credentials

**Required Fields (varies by provider):**
- **Access Token** (required for all)
- **Client ID** (optional for OAuth)
- **Client Secret** (optional for OAuth)
- **Refresh Token** (optional, for auto-renewal)
- **Ad Account ID** (required for ad platforms)

**Optional Fields:**
- **Label** - Custom name (e.g., "Main Instagram - Marketing")
- **Use for Ads** - Toggle if this provider will be used for ad campaigns
- **Redirect URI** - For OAuth flows

#### 4. Test Connection
Click **Save & Test** to verify credentials with a read-only API call.

#### 5. Review Status
- ✅ **Connected** - Working properly
- ⚠️ **Expiring** - Token expires soon
- ❌ **Failed** - Connection issue
- ⭕ **Disconnected** - Not yet tested

---

## API Endpoints

### List All Credentials
```http
GET /brand/integrations
```

**Response:**
```json
{
  "success": true,
  "credentials": [
    {
      "id": 1,
      "provider": "instagram",
      "provider_display_name": "Instagram",
      "label": "Main Instagram",
      "use_for_ads": false,
      "status": "connected",
      "last_tested_at": "2 hours ago",
      "token_expires_at": "2025-12-31 23:59:59",
      "is_expiring_soon": false
    }
  ]
}
```

### Create New Credential
```http
POST /brand/integrations
Content-Type: application/json

{
  "provider": "instagram",
  "label": "Marketing Instagram",
  "access_token": "your_access_token",
  "use_for_ads": false,
  "test_connection": true
}
```

### Test Connection
```http
POST /brand/integrations/{credential}/test
```

### Refresh Token
```http
POST /brand/integrations/{credential}/refresh-token
```

### Update Credential
```http
PUT /brand/integrations/{credential}
Content-Type: application/json

{
  "label": "Updated Label",
  "use_for_ads": true
}
```

### Delete Credential
```http
DELETE /brand/integrations/{credential}
```

---

## Security Features

### 1. Encryption at Rest
All sensitive fields are encrypted using Laravel's encryption:
- Client ID
- Client Secret
- Access Token
- Refresh Token
- Ad Account ID

### 2. Masked Display
Credentials are never shown in full in the UI:
```
Access Token: ****abcd
Client ID: ****xyz123
```

### 3. Role-Based Access
- Only **Brand Admins** and **SuperAdmins** can manage credentials
- Each brand can only access their own credentials
- All actions are logged in audit trail

### 4. Audit Logging
Every action is recorded:
- Who added/edited/removed credentials
- When the action occurred
- What changed (without exposing secrets)

### 5. Rate Limiting
Test connection attempts are rate-limited to prevent:
- Provider API lockouts
- Brute force attempts
- Excessive API usage

---

## Token Management

### Automatic Token Refresh

The system automatically attempts to refresh expiring tokens:

```bash
# Run manually
php artisan providers:check-expiry --auto-refresh

# Schedule in app/Console/Kernel.php
$schedule->command('providers:check-expiry --auto-refresh')->daily();
```

### Expiry Notifications

Brand Admins receive email alerts when tokens are expiring:
- Default: 7 days before expiry
- Configurable via command option
- Includes reconnection instructions

### Manual Reconnection

If auto-refresh fails:
1. Navigate to **Settings → Integrations**
2. Find the expiring provider
3. Click **Reconnect**
4. Complete OAuth flow or enter new credentials

---

## Provider-Specific Setup

### YouTube

**Required Scopes:**
- `https://www.googleapis.com/auth/youtube.readonly`

**Setup Steps:**
1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create OAuth 2.0 credentials
3. Add authorized redirect URI: `https://yourdomain.com/brand/integrations/oauth/callback/google`
4. Copy Client ID and Client Secret
5. Use OAuth flow or manually enter tokens

**Token Expiry:** 1 hour (auto-refreshable with refresh token)

---

### Instagram

**Required Scopes:**
- `instagram_basic`
- `instagram_content_publish`

**Setup Steps:**
1. Go to [Facebook Developers](https://developers.facebook.com/)
2. Create a Facebook App
3. Add Instagram Basic Display or Instagram Graph API
4. Configure OAuth redirect URI
5. Generate long-lived access token

**Token Expiry:** 60 days (can be refreshed)

---

### TikTok

**Required Scopes:**
- `user.info.basic`
- `video.list`

**Setup Steps:**
1. Go to [TikTok for Developers](https://developers.tiktok.com/)
2. Create an app
3. Configure OAuth settings
4. Obtain Client Key and Client Secret

**Token Expiry:** 24 hours (refreshable)

---

### LinkedIn

**Required Scopes:**
- `r_liteprofile`
- `w_member_social`

**Setup Steps:**
1. Go to [LinkedIn Developers](https://www.linkedin.com/developers/)
2. Create an app
3. Add OAuth 2.0 redirect URLs
4. Copy Client ID and Client Secret

**Token Expiry:** 60 days (refreshable)

---

### X (Twitter)

**Required Scopes:**
- `tweet.read`
- `users.read`
- `offline.access`

**Setup Steps:**
1. Go to [Twitter Developer Portal](https://developer.twitter.com/)
2. Create a project and app
3. Enable OAuth 2.0
4. Configure callback URLs
5. Copy Client ID and Client Secret

**Token Expiry:** 2 hours (refreshable with refresh token)

---

### Facebook Ads

**Required Scopes:**
- `ads_management`
- `ads_read`

**Setup Steps:**
1. Go to [Facebook Business Manager](https://business.facebook.com/)
2. Create a system user or use personal account
3. Generate access token with ads permissions
4. Find your Ad Account ID (format: `act_123456789`)
5. Enter credentials in the system

**Token Expiry:** 60 days (refreshable)

---

### Google Ads

**Required Scopes:**
- `https://www.googleapis.com/auth/adwords`

**Setup Steps:**
1. Go to [Google Ads API Center](https://ads.google.com/aw/apicenter)
2. Apply for API access
3. Create OAuth 2.0 credentials in Google Cloud Console
4. Link Google Ads account
5. Obtain Customer ID

**Token Expiry:** 1 hour (auto-refreshable)

---

### Custom Provider

For proprietary or unsupported platforms:

**Required Fields:**
- Access Token
- Optional: Client ID, Client Secret, Ad Account ID

**Note:** Custom providers require manual token management and testing.

---

## Troubleshooting

### Connection Test Failed

**Common Issues:**

1. **Invalid Credentials**
   - Verify Client ID and Client Secret
   - Ensure Access Token is not expired
   - Check for typos

2. **Insufficient Permissions**
   - Verify all required scopes are granted
   - Reconnect with correct permissions

3. **Rate Limit Exceeded**
   - Wait before retrying
   - Check provider's rate limit documentation

4. **Invalid Redirect URI**
   - Ensure redirect URI matches exactly in provider settings
   - Include protocol (https://)

### Token Expired

**Solutions:**
1. Use **Refresh Token** button if available
2. Reconnect account via OAuth
3. Generate new long-lived token from provider

### Ads Not Publishing

**Checklist:**
- [ ] Provider marked as "Use for Ads"
- [ ] Token has ads management permissions
- [ ] Ad Account ID is correct
- [ ] Provider status is "Connected"
- [ ] No rate limits exceeded

### Email Notifications Not Received

**Check:**
1. Email configuration in `.env`
2. Queue worker is running: `php artisan queue:work`
3. Notification preferences in user settings

---

## Best Practices

### 1. Use Labels
Give meaningful names to distinguish multiple accounts:
- ✅ "Main Instagram - Marketing"
- ✅ "Secondary FB Ads - Retargeting"
- ❌ "Instagram 1"

### 2. Regular Testing
Test connections monthly to catch issues early:
```bash
php artisan providers:check-expiry --days=30
```

### 3. Monitor Expiry
Set up daily cron job:
```bash
0 9 * * * cd /path/to/app && php artisan providers:check-expiry --auto-refresh
```

### 4. Backup Credentials
Keep secure backup of:
- Client IDs
- Client Secrets
- Refresh Tokens (if applicable)

### 5. Rotate Tokens
Periodically regenerate tokens for security:
- Every 90 days for production
- After team member changes
- If suspicious activity detected

---

## Support

For additional help:
- **Documentation:** `/docs/providers/`
- **Support Email:** support@yourdomain.com
- **Developer Portal:** [Link to your developer docs]

---

## Changelog

### Version 1.0.0 (2025-09-30)
- Initial release
- Support for 8 providers
- OAuth 2.0 integration
- Automatic token refresh
- Email notifications
- Audit logging
- Encryption at rest