<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Tenant;

class TenantsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
        {
            // Create tenant only if it doesn't already exist
            if (!Tenant::where('domain', 'demo.local')->exists()) {
                Tenant::create([
                    'name' => 'DemoTenant',
                    'domain' => 'demo.local',
                    'plan_id' => null,
                    'billing_info' => null,
                    'active' => true,
                ]);
            }
        }
}
