<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('provider_credentials', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->string('provider'); // youtube, instagram, tiktok, linkedin, twitter, facebook_ads, google_ads, custom
            $table->string('label')->nullable(); // e.g., "Main Instagram - Marketing"
            $table->boolean('use_for_ads')->default(false);
            $table->boolean('is_default')->default(false); // Default provider for ads
            
            // OAuth credentials (encrypted)
            $table->text('client_id')->nullable();
            $table->text('client_secret')->nullable();
            $table->text('access_token')->nullable();
            $table->text('refresh_token')->nullable();
            
            // Additional fields
            $table->text('ad_account_id')->nullable();
            $table->json('scopes')->nullable();
            $table->string('redirect_uri')->nullable();
            
            // Token expiry tracking
            $table->timestamp('token_expires_at')->nullable();
            $table->boolean('expiry_alert_sent')->default(false);
            
            // Connection status
            $table->enum('status', ['connected', 'expiring', 'failed', 'disconnected'])->default('disconnected');
            $table->timestamp('last_tested_at')->nullable();
            $table->text('last_error')->nullable();
            
            // Audit fields
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index(['brand_id', 'provider']);
            $table->index(['brand_id', 'use_for_ads']);
            $table->index('status');
            $table->index('token_expires_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('provider_credentials');
    }
};