<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reputation_audit_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->foreignId('reputation_score_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('reputation_driver_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            
            // Action details
            $table->enum('action', [
                'score_calculated',
                'score_recalculated',
                'driver_added',
                'driver_resolved',
                'manual_override',
                'alert_triggered',
                'threshold_changed',
                'settings_updated'
            ]);
            
            $table->text('description');
            
            // Before/After state for changes
            $table->json('before_state')->nullable();
            $table->json('after_state')->nullable();
            
            // Context
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->json('metadata')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['brand_id', 'created_at']);
            $table->index('reputation_score_id');
            $table->index('action');
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reputation_audit_logs');
    }
};