<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reputation_drivers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('reputation_score_id')->constrained()->onDelete('cascade');
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            
            // Driver type and impact
            $table->enum('type', ['positive', 'negative', 'neutral'])->default('neutral');
            $table->enum('category', [
                'social_engagement',
                'review',
                'press_mention',
                'influencer_mention',
                'complaint',
                'response_time',
                'legal_regulatory',
                'other'
            ]);
            
            // Source information
            $table->string('source_type'); // post, article, review, comment, etc.
            $table->string('source_id')->nullable(); // ID in source system
            $table->string('source_url')->nullable();
            $table->string('source_platform')->nullable(); // Twitter, Instagram, etc.
            $table->text('source_content')->nullable(); // Excerpt or summary
            
            // Impact metrics
            $table->decimal('impact_score', 5, 2)->default(0); // How much this affected overall score
            $table->integer('engagement_count')->default(0); // Likes, shares, views
            $table->decimal('sentiment_value', 3, 2)->nullable(); // -1 to 1
            
            // Metadata
            $table->timestamp('occurred_at');
            $table->json('metadata')->nullable(); // Additional context
            
            // Manual overrides
            $table->boolean('is_resolved')->default(false);
            $table->text('resolution_note')->nullable();
            $table->foreignId('resolved_by')->nullable()->constrained('users');
            $table->timestamp('resolved_at')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['reputation_score_id', 'type']);
            $table->index(['brand_id', 'occurred_at']);
            $table->index('impact_score');
            $table->index('is_resolved');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reputation_drivers');
    }
};