<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('campaign_financials', function (Blueprint $table) {
            $table->id();
            $table->foreignId('campaign_id')->constrained()->onDelete('cascade');
            $table->foreignId('brand_id')->constrained('users')->onDelete('cascade');
            
            // Spend Data
            $table->decimal('ad_spend', 15, 2)->default(0);
            $table->decimal('influencer_payments', 15, 2)->default(0);
            $table->decimal('production_costs', 15, 2)->default(0);
            $table->decimal('other_costs', 15, 2)->default(0);
            $table->decimal('total_spend', 15, 2)->default(0);
            
            // Performance Data
            $table->bigInteger('clicks')->default(0);
            $table->bigInteger('impressions')->default(0);
            $table->bigInteger('conversions')->default(0);
            $table->decimal('avg_order_value', 10, 2)->default(0);
            $table->decimal('total_revenue', 15, 2)->default(0);
            
            // Calculated Metrics
            $table->decimal('roi_percentage', 10, 2)->nullable();
            $table->integer('breakeven_days')->nullable();
            $table->decimal('cost_per_click', 10, 2)->nullable();
            $table->decimal('cost_per_conversion', 10, 2)->nullable();
            $table->decimal('conversion_rate', 10, 2)->nullable();
            
            // Period tracking
            $table->date('period_start');
            $table->date('period_end');
            
            // Metadata
            $table->json('spend_breakdown')->nullable();
            $table->json('performance_metrics')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index(['campaign_id', 'period_start', 'period_end']);
            $table->index('brand_id');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaign_financials');
    }
};