<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conversation_id')->constrained('support_conversations')->onDelete('cascade');
            $table->enum('sender_type', ['customer', 'bot', 'agent'])->default('customer');
            $table->foreignId('sender_id')->nullable()->constrained('users')->onDelete('set null');
            $table->text('message_text');
            $table->text('message_text_redacted')->nullable(); // PII redacted version
            $table->json('detected_pii')->nullable(); // Types of PII detected
            $table->text('bot_response')->nullable();
            $table->json('citations')->nullable(); // Source documents used
            $table->decimal('confidence_score', 5, 2)->nullable(); // 0-100
            $table->boolean('requires_escalation')->default(false);
            $table->string('escalation_reason')->nullable();
            $table->json('metadata')->nullable(); // intent, entities, sentiment, etc.
            $table->boolean('helpful_flag')->nullable(); // User feedback
            $table->text('feedback_comment')->nullable();
            $table->timestamps();

            $table->index(['conversation_id', 'created_at']);
            $table->index(['sender_type', 'created_at']);
            $table->index('confidence_score');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_messages');
    }
};