<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('localization_cache', function (Blueprint $table) {
            $table->id();
            $table->text('source_text_hash'); // hash of source text for quick lookup
            $table->string('source_locale', 10)->default('en');
            $table->string('target_locale', 10);
            $table->string('tone')->default('neutral');
            $table->text('source_text');
            $table->text('translated_text');
            $table->text('cultural_notes')->nullable();
            $table->string('ai_provider')->nullable(); // 'openai', 'anthropic', etc.
            $table->integer('usage_count')->default(1);
            $table->timestamp('last_used_at')->useCurrent();
            $table->timestamps();

            // Indexes for fast lookup
            $table->index(['source_text_hash', 'target_locale', 'tone'], 'cache_lookup_idx');
            $table->index('last_used_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('localization_cache');
    }
};