<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('performance_forecasts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            
            // Campaign or social account context
            $table->json('campaign_ids')->nullable(); // Array of campaign IDs
            $table->json('social_account_ids')->nullable(); // Array of social account IDs
            
            // Input parameters
            $table->date('start_date');
            $table->date('end_date');
            $table->integer('forecast_days'); // Number of days to forecast
            $table->json('input_metrics'); // Historical metrics used for forecast
            
            // Forecast strategy/scenario
            $table->enum('scenario', ['conservative', 'balanced', 'aggressive'])->default('balanced');
            
            // Forecast results
            $table->json('predicted_timeseries'); // Time series data with predictions
            $table->json('error_bands'); // 95% confidence intervals
            $table->json('roi_estimates'); // ROI predictions
            $table->text('insights_text')->nullable(); // AI-generated insights
            $table->json('insights_meta')->nullable(); // Structured insights data
            
            // Forecast metadata
            $table->string('status')->default('pending'); // pending, processing, completed, failed
            $table->text('error_message')->nullable();
            $table->timestamp('completed_at')->nullable();
            
            // Audit fields
            $table->timestamps();
            
            // Indexes for performance
            $table->index('brand_id');
            $table->index('created_by');
            $table->index('status');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('performance_forecasts');
    }
};
