<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ad_performance_metrics', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ad_variant_id');
            $table->string('platform'); // facebook, instagram, twitter, etc.
            $table->unsignedBigInteger('impressions')->default(0);
            $table->unsignedBigInteger('clicks')->default(0);
            $table->unsignedBigInteger('conversions')->default(0);
            $table->decimal('spend', 12, 2)->default(0);
            $table->decimal('ctr', 8, 4)->default(0); // Click-through rate
            $table->decimal('conversion_rate', 8, 4)->default(0);
            $table->decimal('cpc', 12, 4)->default(0); // Cost per click
            $table->decimal('cpm', 12, 4)->default(0); // Cost per thousand impressions
            $table->decimal('roas', 12, 4)->default(0); // Return on ad spend
            $table->timestamp('last_synced_at')->nullable();
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('ad_variant_id')->references('id')->on('ad_variants')->onDelete('cascade');

            // Indexes
            $table->index('ad_variant_id');
            $table->index('platform');
            $table->index('last_synced_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ad_performance_metrics');
    }
};