<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('auto_reply_suggestions', function (Blueprint $table) {
            // Check if is_favorite column exists before adding it
            if (!Schema::hasColumn('auto_reply_suggestions', 'is_favorite')) {
                $table->boolean('is_favorite')->default(false)->after('is_posted');
                $table->index('is_favorite');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('auto_reply_suggestions', function (Blueprint $table) {
            // Check if is_favorite column exists before dropping it
            if (Schema::hasColumn('auto_reply_suggestions', 'is_favorite')) {
                $table->dropIndex(['is_favorite']);
                $table->dropColumn('is_favorite');
            }
        });
    }
};