<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the single brand_id unique constraint exists before dropping it
        if ($this->indexExists('auto_reply_settings', 'auto_reply_settings_brand_id_unique')) {
            Schema::table('auto_reply_settings', function (Blueprint $table) {
                $table->dropUnique(['brand_id']);
            });
        }
        
        // Check if the composite unique constraint already exists
        if (!$this->indexExists('auto_reply_settings', 'auto_reply_settings_brand_id_creator_id_unique')) {
            Schema::table('auto_reply_settings', function (Blueprint $table) {
                $table->unique(['brand_id', 'creator_id']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Check if the composite unique constraint exists before dropping it
        if ($this->indexExists('auto_reply_settings', 'auto_reply_settings_brand_id_creator_id_unique')) {
            Schema::table('auto_reply_settings', function (Blueprint $table) {
                $table->dropUnique(['brand_id', 'creator_id']);
            });
        }
        
        // Check if the single brand_id unique constraint already exists
        if (!$this->indexExists('auto_reply_settings', 'auto_reply_settings_brand_id_unique')) {
            Schema::table('auto_reply_settings', function (Blueprint $table) {
                $table->unique(['brand_id']);
            });
        }
    }
    
    /**
     * Check if an index exists on a table.
     *
     * @param string $table
     * @param string $indexName
     * @return bool
     */
    protected function indexExists($table, $indexName)
    {
        try {
            $indexes = DB::select("SHOW INDEX FROM {$table} WHERE Key_name = ?", [$indexName]);
            return count($indexes) > 0;
        } catch (\Exception $e) {
            return false;
        }
    }
};