<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('social_comments', function (Blueprint $table) {
            // Check if creator_id column exists before adding it
            if (!Schema::hasColumn('social_comments', 'creator_id')) {
                $table->unsignedBigInteger('creator_id')->nullable()->after('brand_id');
                
                $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('social_comments', function (Blueprint $table) {
            // Check if creator_id column exists before dropping it
            if (Schema::hasColumn('social_comments', 'creator_id')) {
                $table->dropForeign(['creator_id']);
                $table->dropColumn('creator_id');
            }
        });
    }
};