<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('auto_reply_settings', function (Blueprint $table) {
            // Check if creator_guidelines column exists before adding it
            if (!Schema::hasColumn('auto_reply_settings', 'creator_guidelines')) {
                $table->json('creator_guidelines')->nullable()->after('brand_guidelines');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('auto_reply_settings', function (Blueprint $table) {
            // Check if creator_guidelines column exists before dropping it
            if (Schema::hasColumn('auto_reply_settings', 'creator_guidelines')) {
                $table->dropColumn('creator_guidelines');
            }
        });
    }
};