<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('auto_reply_suggestions', function (Blueprint $table) {
            // Check if creator_id column exists before adding it
            if (!Schema::hasColumn('auto_reply_suggestions', 'creator_id')) {
                $table->unsignedBigInteger('creator_id')->nullable()->after('brand_id');
                $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            }
            
            // Check if preferred_tone column exists before adding it
            if (!Schema::hasColumn('auto_reply_suggestions', 'preferred_tone')) {
                $table->string('preferred_tone')->nullable()->after('brand_voice');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('auto_reply_suggestions', function (Blueprint $table) {
            // Check if creator_id column exists before dropping it
            if (Schema::hasColumn('auto_reply_suggestions', 'creator_id')) {
                $table->dropForeign(['creator_id']);
                $table->dropColumn('creator_id');
            }
            
            // Check if preferred_tone column exists before dropping it
            if (Schema::hasColumn('auto_reply_suggestions', 'preferred_tone')) {
                $table->dropColumn('preferred_tone');
            }
        });
    }
};