<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_ideas', function (Blueprint $table) {
                    $table->id();
                    $table->unsignedBigInteger('brand_id');
                    $table->unsignedBigInteger('campaign_id')->nullable();
                    $table->unsignedBigInteger('user_id'); // For audit trail
                    $table->text('caption');
                    $table->json('hashtags')->nullable();
                    $table->text('creative_hints')->nullable();
                    $table->string('status')->default('draft'); // draft, scheduled, posted, etc.
                    $table->timestamps();
                    
                    $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
                    $table->foreign('campaign_id')->references('id')->on('campaigns')->onDelete('set null');
                    $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_ideas');
    }
};
