<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reel_post_attempts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('scheduled_reel_id');
            $table->string('provider');
            $table->json('request_payload')->nullable();
            $table->json('response_summary')->nullable();
            $table->timestamps();
            
            $table->foreign('scheduled_reel_id')->references('id')->on('scheduled_reels')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reel_post_attempts');
    }
};