<?php

namespace Database\Factories;

use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;

class TenantFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Tenant::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
   {
       return [
           'name' => $this->faker->company,
           'domain' => $this->faker->unique()->domainName,
           'plan_id' => 1,
           'billing_info' => [],
           'active' => true,
       ];
   }
}