<?php

namespace Database\Factories;

use App\Models\SocialAccount;
use App\Models\SocialPost;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SocialPost>
 */
class SocialPostFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'social_account_id' => SocialAccount::factory(),
            'provider_post_id' => $this->faker->unique()->uuid,
            'title' => $this->faker->sentence,
            'caption' => $this->faker->sentence,
            'content' => $this->faker->paragraph,
            'media' => [
                'thumbnail' => $this->faker->imageUrl(400, 300),
            ],
            'permalink' => $this->faker->url,
            'published_at' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'metrics' => [
                'views' => $this->faker->numberBetween(0, 100000),
                'likes' => $this->faker->numberBetween(0, 10000),
                'comments' => $this->faker->numberBetween(0, 1000),
                'shares' => $this->faker->numberBetween(0, 1000),
            ],
            'raw_json' => [],
            'last_checked_at' => $this->faker->dateTimeBetween('-1 month', 'now'),
        ];
    }
}
