<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Title
    |--------------------------------------------------------------------------
    |
    | Here you can change the default title of your admin panel.
    |
    | For detailed instructions you can look the title section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'title' => 'AdminLTE 3',
    'title_prefix' => '',
    'title_postfix' => '',

    /*
    |--------------------------------------------------------------------------
    | Favicon
    |--------------------------------------------------------------------------
    |
    | Here you can activate the favicon.
    |
    | For detailed instructions you can look the favicon section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'use_ico_only' => false,
    'use_full_favicon' => false,

    /*
    |--------------------------------------------------------------------------
    | Google Fonts
    |--------------------------------------------------------------------------
    |
    | Here you can allow or not the use of external google fonts. Disabling the
    | google fonts may be useful if your admin panel internet access is
    | restricted somehow.
    |
    | For detailed instructions you can look the google fonts section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'google_fonts' => [
        'allowed' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Admin Panel Logo
    |--------------------------------------------------------------------------
    |
    | Here you can change the logo of your admin panel.
    |
    | For detailed instructions you can look the logo section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'logo' => '<b>Multi</b>SaaS',
    'logo_img' => 'vendor/adminlte/dist/img/AdminLTELogo.png',
    'logo_img_class' => 'brand-image img-circle elevation-3',
    'logo_img_xl' => null,
    'logo_img_xl_class' => 'brand-image-xs',
    'logo_img_alt' => 'Admin Logo',

    /*
    |--------------------------------------------------------------------------
    | Authentication Logo
    |--------------------------------------------------------------------------
    |
    | Here you can setup an alternative logo to use on your login and register
    | screens. When disabled, the admin panel logo will be used instead.
    |
    | For detailed instructions you can look the auth logo section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'auth_logo' => [
        'enabled' => false,
        'img' => [
            'path' => 'vendor/adminlte/dist/img/AdminLTELogo.png',
            'alt' => 'Auth Logo',
            'class' => '',
            'width' => 50,
            'height' => 50,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Preloader Animation
    |--------------------------------------------------------------------------
    |
    | Here you can change the preloader animation configuration. Currently, two
    | modes are supported: 'fullscreen' for a fullscreen preloader animation
    | and 'cwrapper' to attach the preloader animation into the content-wrapper
    | element and avoid overlapping it with the sidebars and the top navbar.
    |
    | For detailed instructions you can look the preloader section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'preloader' => [
        'enabled' => true,
        'mode' => 'fullscreen',
        'img' => [
            'path' => 'vendor/adminlte/dist/img/AdminLTELogo.png',
            'alt' => 'AdminLTE Preloader Image',
            'effect' => 'animation__shake',
            'width' => 60,
            'height' => 60,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | User Menu
    |--------------------------------------------------------------------------
    |
    | Here you can activate and change the user menu.
    |
    | For detailed instructions you can look the user menu section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'usermenu_enabled' => true,
    'usermenu_header' => false,
    'usermenu_header_class' => 'bg-primary',
    'usermenu_image' => false,
    'usermenu_desc' => false,
    'usermenu_profile_url' => false,

    /*
    |--------------------------------------------------------------------------
    | Layout
    |--------------------------------------------------------------------------
    |
    | Here we change the layout of your admin panel.
    |
    | For detailed instructions you can look the layout section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'layout_topnav' => null,
    'layout_boxed' => null,
    'layout_fixed_sidebar' => null,
    'layout_fixed_navbar' => null,
    'layout_fixed_footer' => null,
    'layout_dark_mode' => null,

    /*
    |--------------------------------------------------------------------------
    | Authentication Views Classes
    |--------------------------------------------------------------------------
    |
    | Here you can change the look and behavior of the authentication views.
    |
    | For detailed instructions you can look the auth classes section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'classes_auth_card' => 'card-outline card-primary',
    'classes_auth_header' => '',
    'classes_auth_body' => '',
    'classes_auth_footer' => '',
    'classes_auth_icon' => '',
    'classes_auth_btn' => 'btn-flat btn-primary',

    /*
    |--------------------------------------------------------------------------
    | Admin Panel Classes
    |--------------------------------------------------------------------------
    |
    | Here you can change the look and behavior of the admin panel.
    |
    | For detailed instructions you can look the admin panel classes here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'classes_body' => '',
    'classes_brand' => '',
    'classes_brand_text' => '',
    'classes_content_wrapper' => '',
    'classes_content_header' => '',
    'classes_content' => '',
    'classes_sidebar' => 'sidebar-dark-primary elevation-4',
    'classes_sidebar_nav' => '',
    'classes_topnav' => 'navbar-white navbar-light',
    'classes_topnav_nav' => 'navbar-expand',
    'classes_topnav_container' => 'container',

    /*
    |--------------------------------------------------------------------------
    | Sidebar
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar of the admin panel.
    |
    | For detailed instructions you can look the sidebar section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'sidebar_mini' => 'lg',
    'sidebar_collapse' => false,
    'sidebar_collapse_auto_size' => false,
    'sidebar_collapse_remember' => false,
    'sidebar_collapse_remember_no_transition' => true,
    'sidebar_scrollbar_theme' => 'os-theme-light',
    'sidebar_scrollbar_auto_hide' => 'l',
    'sidebar_nav_accordion' => true,
    'sidebar_nav_animation_speed' => 300,

    /*
    |--------------------------------------------------------------------------
    | Control Sidebar (Right Sidebar)
    |--------------------------------------------------------------------------
    |
    | Here we can modify the right sidebar aka control sidebar of the admin panel.
    |
    | For detailed instructions you can look the right sidebar section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'right_sidebar' => false,
    'right_sidebar_icon' => 'fas fa-cogs',
    'right_sidebar_theme' => 'dark',
    'right_sidebar_slide' => true,
    'right_sidebar_push' => true,
    'right_sidebar_scrollbar_theme' => 'os-theme-light',
    'right_sidebar_scrollbar_auto_hide' => 'l',

    /*
    |--------------------------------------------------------------------------
    | URLs
    |--------------------------------------------------------------------------
    |
    | Here we can modify the url settings of the admin panel.
    |
    | For detailed instructions you can look the urls section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'use_route_url' => false,
    'dashboard_url' => 'home',
    'logout_url' => 'logout',
    'login_url' => 'login',
    'register_url' => 'register',
    'password_reset_url' => 'password/reset',
    'password_email_url' => 'password/email',
    'profile_url' => false,
    'disable_darkmode_routes' => false,

    /*
    |--------------------------------------------------------------------------
    | Laravel Asset Bundling
    |--------------------------------------------------------------------------
    |
    | Here we can enable the Laravel Asset Bundling option for the admin panel.
    | Currently, the next modes are supported: 'mix', 'vite' and 'vite_js_only'.
    | When using 'vite_js_only', it's expected that your CSS is imported using
    | JavaScript. Typically, in your application's 'resources/js/app.js' file.
    | If you are not using any of these, leave it as 'false'.
    |
    | For detailed instructions you can look the asset bundling section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Other-Configuration
    |
    */

    'laravel_asset_bundling' => false,
    'laravel_css_path' => 'css/app.css',
    'laravel_js_path' => 'js/app.js',

    /*
    |--------------------------------------------------------------------------
    | Menu Items
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar/top navigation of the admin panel.
    |
    | For detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Menu-Configuration
    |
    */

    'menu' => [
            // Navbar items:
            [
                'type' => 'navbar-search',
                'text' => 'search',
                'topnav_right' => true,
            ],
            [
                'type' => 'fullscreen-widget',
                'topnav_right' => true,
            ],
    
            // Sidebar items:
            [
                'type' => 'sidebar-menu-search',
                'text' => 'search',
                'id' => 'sidebar-search',
            ],
            [
                'text' => 'login',
                'url' => 'login',
                'icon' => 'fas fa-sign-in-alt',
                'can' => 'manage tenants', // Only visible to users who can manage tenants
            ],
            [
                'text' => 'register',
                'url' => 'register',
                'icon' => 'fas fa-user-plus',
                'can' => 'manage tenants', // Only visible to users who can manage tenants
            ],
            
            // SuperAdmin menu items - Complete Navigation Structure
            [
                'text' => 'Dashboard',
                'route' => 'superadmin.dashboard',
                'icon' => 'fas fa-fw fa-tachometer-alt',
                'can' => 'superadmin',
                'label' => 'badge_dashboard_count',
                'label_color' => 'success',
            ],
            [
                'text' => 'Tenants (Brands)',
                'icon' => 'fas fa-fw fa-building',
                'can' => 'superadmin',
                'label' => 'badge_tenants_count',
                'label_color' => 'info',
                'submenu' => [
                    [
                        'text' => 'All Tenants',
                        'route' => 'superadmin.tenants.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Create Tenant',
                        'route' => 'superadmin.tenants.create',
                        'icon' => 'fas fa-fw fa-plus-circle',
                    ],
                    [
                        'text' => 'Pending Requests',
                        'route' => 'superadmin.requests.index',
                        'icon' => 'fas fa-fw fa-clock',
                        'label' => 'badge_pending_requests',
                        'label_color' => 'warning',
                    ],
                ],
            ],
            [
                'text' => 'Agencies',
                'icon' => 'fas fa-fw fa-briefcase',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'All Agencies',
                        'route' => 'superadmin.agencies.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Create Agency',
                        'route' => 'superadmin.agencies.create',
                        'icon' => 'fas fa-fw fa-plus-circle',
                    ],
                ],
            ],
            [
                'text' => 'Users',
                'icon' => 'fas fa-fw fa-users',
                'can' => 'superadmin',
                'label' => 'badge_users_count',
                'label_color' => 'primary',
                'submenu' => [
                    [
                        'text' => 'All Users',
                        'route' => 'superadmin.users.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Create User',
                        'route' => 'superadmin.users.create',
                        'icon' => 'fas fa-fw fa-user-plus',
                    ],
                    [
                        'text' => 'Impersonate User',
                        'route' => 'superadmin.users.impersonate',
                        'icon' => 'fas fa-fw fa-user-secret',
                    ],
                ],
            ],
            [
                'text' => 'Roles & Permissions',
                'icon' => 'fas fa-fw fa-user-shield',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Roles',
                        'route' => 'superadmin.roles.index',
                        'icon' => 'fas fa-fw fa-user-tag',
                    ],
                    [
                        'text' => 'Permissions',
                        'route' => 'superadmin.permissions.index',
                        'icon' => 'fas fa-fw fa-key',
                    ],
                ],
            ],
            [
                'text' => 'Campaigns',
                'icon' => 'fas fa-fw fa-bullhorn',
                'can' => 'superadmin',
                'label' => 'badge_campaigns_count',
                'label_color' => 'success',
                'submenu' => [
                    [
                        'text' => 'All Campaigns',
                        'route' => 'superadmin.campaigns.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Active Campaigns',
                        'route' => 'superadmin.campaigns.active',
                        'icon' => 'fas fa-fw fa-play-circle',
                        'label' => 'badge_active_campaigns',
                        'label_color' => 'success',
                    ],
                ],
            ],
            [
                'text' => 'Proposals',
                'icon' => 'fas fa-fw fa-file-contract',
                'can' => 'superadmin',
                'label' => 'badge_proposals_count',
                'label_color' => 'warning',
                'submenu' => [
                    [
                        'text' => 'All Proposals',
                        'route' => 'superadmin.proposals.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Pending Proposals',
                        'route' => 'superadmin.proposals.pending',
                        'icon' => 'fas fa-fw fa-clock',
                        'label' => 'badge_pending_proposals',
                        'label_color' => 'warning',
                    ],
                ],
            ],
            [
                'text' => 'AI Jobs',
                'icon' => 'fas fa-fw fa-robot',
                'can' => 'superadmin',
                'label' => 'badge_ai_jobs_count',
                'label_color' => 'info',
                'submenu' => [
                    [
                        'text' => 'All AI Jobs',
                        'route' => 'admin.ai-jobs.index',
                        'icon' => 'fas fa-fw fa-tasks',
                    ],
                    [
                        'text' => 'Failed Jobs',
                        'route' => 'superadmin.ai-jobs.failed',
                        'icon' => 'fas fa-fw fa-exclamation-triangle',
                        'label' => 'badge_failed_jobs',
                        'label_color' => 'danger',
                    ],
                    [
                        'text' => 'AI Proposals',
                        'route' => 'superadmin.ai-proposals.index',
                        'icon' => 'fas fa-fw fa-file-contract',
                    ],
                    [
                        'text' => 'Token Usage',
                        'route' => 'superadmin.ai-proposals.token-usage',
                        'icon' => 'fas fa-fw fa-coins',
                    ],
                ],
            ],
            [
                'text' => 'Queue & Workers',
                'icon' => 'fas fa-fw fa-server',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Queue Status',
                        'route' => 'superadmin.queue.status',
                        'icon' => 'fas fa-fw fa-heartbeat',
                    ],
                    [
                        'text' => 'Failed Jobs',
                        'route' => 'superadmin.queue.failed',
                        'icon' => 'fas fa-fw fa-times-circle',
                        'label' => 'badge_queue_failed',
                        'label_color' => 'danger',
                    ],
                    [
                        'text' => 'Workers',
                        'route' => 'superadmin.queue.workers',
                        'icon' => 'fas fa-fw fa-cogs',
                    ],
                ],
            ],
            [
                'text' => 'Reels / Media',
                'icon' => 'fas fa-fw fa-video',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'All Reels',
                        'route' => 'superadmin.reels.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Processing Queue',
                        'route' => 'superadmin.reels.processing',
                        'icon' => 'fas fa-fw fa-spinner',
                        'label' => 'badge_processing_reels',
                        'label_color' => 'info',
                    ],
                    [
                        'text' => 'Failed Reels',
                        'route' => 'superadmin.reels.failed',
                        'icon' => 'fas fa-fw fa-exclamation-circle',
                    ],
                ],
            ],
            [
                'text' => 'Integrations',
                'icon' => 'fas fa-fw fa-plug',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Social Platforms',
                        'route' => 'superadmin.integrations.social',
                        'icon' => 'fas fa-fw fa-share-alt',
                    ],
                    [
                        'text' => 'AI Providers',
                        'route' => 'superadmin.integrations.ai',
                        'icon' => 'fas fa-fw fa-brain',
                    ],
                    [
                        'text' => 'Reel Processors',
                        'route' => 'superadmin.integrations.reels',
                        'icon' => 'fas fa-fw fa-film',
                    ],
                    [
                        'text' => 'API Keys',
                        'route' => 'superadmin.integrations.api-keys',
                        'icon' => 'fas fa-fw fa-key',
                    ],
                ],
            ],
            [
                'text' => 'Billing & Subscriptions',
                'icon' => 'fas fa-fw fa-credit-card',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Revenue Dashboard',
                        'route' => 'superadmin.billing.dashboard',
                        'icon' => 'fas fa-fw fa-chart-line',
                    ],
                    [
                        'text' => 'Subscriptions',
                        'route' => 'superadmin.billing.subscriptions',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Invoices',
                        'route' => 'superadmin.billing.invoices',
                        'icon' => 'fas fa-fw fa-file-invoice',
                    ],
                    [
                        'text' => 'Failed Payments',
                        'route' => 'superadmin.billing.failed',
                        'icon' => 'fas fa-fw fa-exclamation-triangle',
                        'label' => 'badge_failed_payments',
                        'label_color' => 'danger',
                    ],
                    [
                        'text' => 'Plans',
                        'route' => 'superadmin.billing.plans',
                        'icon' => 'fas fa-fw fa-tags',
                    ],
                ],
            ],
            [
                'text' => 'System Logs',
                'icon' => 'fas fa-fw fa-file-alt',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Application Logs',
                        'route' => 'superadmin.logs.application',
                        'icon' => 'fas fa-fw fa-terminal',
                    ],
                    [
                        'text' => 'Audit Logs',
                        'route' => 'superadmin.logs.audit',
                        'icon' => 'fas fa-fw fa-history',
                    ],
                    [
                        'text' => 'Error Logs',
                        'route' => 'superadmin.logs.errors',
                        'icon' => 'fas fa-fw fa-bug',
                        'label' => 'badge_errors',
                        'label_color' => 'danger',
                    ],
                    [
                        'text' => 'Export Logs',
                        'route' => 'superadmin.logs.export',
                        'icon' => 'fas fa-fw fa-download',
                    ],
                ],
            ],
            [
                'text' => 'Alerts & Incidents',
                'icon' => 'fas fa-fw fa-bell',
                'can' => 'superadmin',
                'label' => 'badge_alerts_count',
                'label_color' => 'danger',
                'submenu' => [
                    [
                        'text' => 'Active Alerts',
                        'route' => 'superadmin.alerts.active',
                        'icon' => 'fas fa-fw fa-exclamation-circle',
                        'label' => 'badge_active_alerts',
                        'label_color' => 'danger',
                    ],
                    [
                        'text' => 'Incidents',
                        'route' => 'superadmin.alerts.incidents',
                        'icon' => 'fas fa-fw fa-fire',
                    ],
                    [
                        'text' => 'Alert Rules',
                        'route' => 'superadmin.alerts.rules',
                        'icon' => 'fas fa-fw fa-sliders-h',
                    ],
                ],
            ],
            [
                'text' => 'Settings',
                'icon' => 'fas fa-fw fa-cog',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Global Settings',
                        'route' => 'superadmin.settings.global',
                        'icon' => 'fas fa-fw fa-globe',
                    ],
                    [
                        'text' => 'Email Configuration',
                        'route' => 'superadmin.settings.email',
                        'icon' => 'fas fa-fw fa-envelope',
                    ],
                    [
                        'text' => 'Security Settings',
                        'route' => 'superadmin.settings.security',
                        'icon' => 'fas fa-fw fa-shield-alt',
                    ],
                    [
                        'text' => 'Backup Settings',
                        'route' => 'superadmin.settings.backup',
                        'icon' => 'fas fa-fw fa-database',
                    ],
                    [
                        'text' => 'Rate Limits',
                        'route' => 'superadmin.settings.rate-limits',
                        'icon' => 'fas fa-fw fa-tachometer-alt',
                    ],
                ],
            ],
            [
                'text' => 'Tools',
                'icon' => 'fas fa-fw fa-tools',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Maintenance Mode',
                        'route' => 'superadmin.tools.maintenance',
                        'icon' => 'fas fa-fw fa-wrench',
                    ],
                    [
                        'text' => 'Task Scheduler',
                        'route' => 'superadmin.tools.scheduler',
                        'icon' => 'fas fa-fw fa-clock',
                    ],
                    [
                        'text' => 'Run Migrations',
                        'route' => 'superadmin.tools.migrations',
                        'icon' => 'fas fa-fw fa-database',
                    ],
                    [
                        'text' => 'Cache Management',
                        'route' => 'superadmin.tools.cache',
                        'icon' => 'fas fa-fw fa-memory',
                    ],
                    [
                        'text' => 'Database Backup',
                        'route' => 'superadmin.tools.backup',
                        'icon' => 'fas fa-fw fa-save',
                    ],
                ],
            ],
            [
                'text' => 'Help & Docs',
                'icon' => 'fas fa-fw fa-question-circle',
                'can' => 'superadmin',
                'submenu' => [
                    [
                        'text' => 'Documentation',
                        'route' => 'superadmin.help.docs',
                        'icon' => 'fas fa-fw fa-book',
                    ],
                    [
                        'text' => 'API Reference',
                        'route' => 'superadmin.help.api',
                        'icon' => 'fas fa-fw fa-code',
                    ],
                    [
                        'text' => 'System Info',
                        'route' => 'superadmin.help.system-info',
                        'icon' => 'fas fa-fw fa-info-circle',
                    ],
                ],
            ],
                
            // BrandAdmin menu items
            [
                'text' => 'Dashboard',
                'route' => 'brand.dashboard',
                'icon' => 'fas fa-fw fa-tachometer-alt',
                'can' => 'brand_admin',
            ],
            [
                'text' => 'Social Connections',
                'route' => 'brand.connections.index',
                'icon' => 'fas fa-fw fa-plug',
                'can' => 'brand_admin',
            ],
            [
                'text' => 'Creators',
                'route' => 'brand.creators.index',
                'icon' => 'fas fa-fw fa-user-friends',
                'can' => 'brand_admin',
            ],
            [
                'text' => 'Marketplace',
                'icon' => 'fas fa-fw fa-store',
                'can' => 'brand_admin', // Only visible to brand admins
                'submenu' => [
                    [
                        'text' => 'Browse Creators',
                        'route' => 'brand.marketplace.index',
                        'icon' => 'fas fa-fw fa-search',
                    ],
                    [
                        'text' => 'My Shortlists',
                        'route' => 'brand.marketplace.shortlists.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Recommendations',
                        'route' => 'brand.marketplace.recommendations.index',
                        'icon' => 'fas fa-fw fa-star',
                    ],
                ],
            ],
            [
                'text' => 'Proposals',
                'icon' => 'fas fa-fw fa-file-contract',
                'can' => 'brand_admin',
                'submenu' => [
                    [
                        'text' => 'All Proposals',
                        'route' => 'brand.proposals.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Create Proposal',
                        'route' => 'brand.proposals.create',
                        'icon' => 'fas fa-fw fa-plus',
                    ],
                    [
                        'text' => 'AI Proposal Generator',
                        'route' => 'brand.ai-proposals.create',
                        'icon' => 'fas fa-fw fa-robot',
                    ],
                ],
            ],
            [
                'text' => 'Campaigns',
                'icon' => 'fas fa-fw fa-bullhorn',
                'can' => 'brand_admin', // Only visible to brand admins
                'submenu' => [
                    [
                        'text' => 'All Campaigns',
                        'route' => 'brand.campaigns.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                    [
                        'text' => 'Create Campaign',
                        'route' => 'brand.campaigns.create',
                        'icon' => 'fas fa-fw fa-plus',
                    ],
                ],
            ],
            [
                'text' => 'Content',
                'icon' => 'fas fa-fw fa-file-alt',
                'can' => 'brand_admin',
                'submenu' => [
                    [
                        'text' => 'Content Ideas',
                        'route' => 'brand.content-ideas.index',
                        'icon' => 'fas fa-fw fa-lightbulb',
                    ],
                    [
                        'text' => 'Scheduled Posts',
                        'route' => 'brand.scheduled-posts.index',
                        'icon' => 'fas fa-fw fa-calendar-alt',
                    ],
                    [
                        'text' => 'Reels',
                        'route' => 'brand.reels.index',
                        'icon' => 'fas fa-fw fa-video',
                    ],
                    [
                        'text' => 'Auto-Replies',
                        'route' => 'brand.auto-replies.index',
                        'icon' => 'fas fa-fw fa-reply-all',
                    ],
                    [
                        'text' => 'Pending Approval',
                        'route' => 'brand.content.pending',
                        'icon' => 'fas fa-fw fa-clock',
                    ],
                ],
            ],
            [
                'text' => 'Analytics',
                'route' => 'brand.analytics.index',
                'icon' => 'fas fa-fw fa-chart-bar',
                'can' => 'brand_admin',
            ],
            [
                'text' => 'Messages',
                'route' => 'messages.index',
                'icon' => 'fas fa-fw fa-envelope',
                'can' => 'brand_admin',
            ],
            [
                'text' => 'Advanced',
                'icon' => 'fas fa-fw fa-tools',
                'can' => 'brand_admin',
                'submenu' => [
                    [
                        'text' => 'Ad Manager',
                        'route' => 'brand.ads.index',
                        'icon' => 'fas fa-fw fa-ad',
                    ],
                    [
                        'text' => 'Performance Forecasting',
                        'route' => 'brand.forecasts.index',
                        'icon' => 'fas fa-fw fa-chart-line',
                    ],
                    [
                        'text' => 'Competitor Insights',
                        'route' => 'brand.competitor-insights.index',
                        'icon' => 'fas fa-fw fa-binoculars',
                    ],
                    [
                        'text' => 'Localization',
                        'route' => 'brand.localization.index',
                        'icon' => 'fas fa-fw fa-globe',
                    ],
                    [
                        'text' => 'Support Bot',
                        'route' => 'brand.support.dashboard',
                        'icon' => 'fas fa-fw fa-robot',
                    ],
                ],
            ],
            [
                'text' => 'Settings',
                'icon' => 'fas fa-fw fa-cog',
                'can' => 'brand_admin',
                'submenu' => [
                    [
                        'text' => 'Profile',
                        'route' => 'profile.edit',
                        'icon' => 'fas fa-fw fa-user',
                    ],
                    [
                        'text' => 'Team Management',
                        'route' => 'brand.users.index',
                        'icon' => 'fas fa-fw fa-users',
                    ],
                    [
                        'text' => 'Auto-Reply Settings',
                        'route' => 'brand.auto-replies.settings',
                        'icon' => 'fas fa-fw fa-cog',
                    ],
                ],
            ],
                
            // Creator menu items
            [
                'text' => 'Dashboard',
                'route' => 'creator.dashboard',
                'icon' => 'fas fa-fw fa-tachometer-alt',
                'can' => 'creator',
            ],
            [
                'text' => 'Social Accounts',
                'route' => 'creator.connections.index',
                'icon' => 'fas fa-fw fa-plug',
                'can' => 'creator',
            ],
            [
                'text' => 'Marketplace',
                'icon' => 'fas fa-fw fa-store',
                'can' => 'creator', // Only visible to creators
                'submenu' => [
                    [
                        'text' => 'Browse Brands',
                        'route' => 'creator.marketplace.index',
                        'icon' => 'fas fa-fw fa-search',
                    ],
                    [
                        'text' => 'My Opportunities',
                        'route' => 'creator.marketplace.opportunities.index',
                        'icon' => 'fas fa-fw fa-briefcase',
                    ],
                ],
            ],
            [
                'text' => 'Proposals',
                'icon' => 'fas fa-fw fa-file-contract',
                'can' => 'creator', // Only visible to creators
                'submenu' => [
                    [
                        'text' => 'Received Proposals',
                        'route' => 'creator.proposals.index',
                        'icon' => 'fas fa-fw fa-file-alt',
                    ],
                    [
                        'text' => 'Create Proposal',
                        'route' => 'creator.proposals.create',
                        'icon' => 'fas fa-fw fa-plus',
                    ],
                ],
            ],
            [
                'text' => 'Campaigns',
                'icon' => 'fas fa-fw fa-bullhorn',
                'can' => 'creator', // Only visible to creators
                'submenu' => [
                    [
                        'text' => 'Invitations',
                        'route' => 'creator.campaigns.invitations.index',
                        'icon' => 'fas fa-fw fa-envelope',
                    ],
                    [
                        'text' => 'My Campaigns',
                        'route' => 'creator.campaigns.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                ],
            ],
            [
                'text' => 'Content',
                'icon' => 'fas fa-fw fa-file-alt',
                'can' => 'creator',
                'submenu' => [
                    [
                        'text' => 'Content Ideas',
                        'route' => 'creator.content-ideas.index',
                        'icon' => 'fas fa-fw fa-lightbulb',
                    ],
                    [
                        'text' => 'Scheduled Posts',
                        'route' => 'creator.scheduled-posts.index',
                        'icon' => 'fas fa-fw fa-calendar-alt',
                    ],
                    [
                        'text' => 'Reels',
                        'route' => 'creator.reels.index',
                        'icon' => 'fas fa-fw fa-video',
                    ],
                    [
                        'text' => 'Auto-Replies',
                        'route' => 'creator.auto-replies.index',
                        'icon' => 'fas fa-fw fa-reply-all',
                    ],
                    [
                        'text' => 'My Posts/Videos',
                        'route' => 'creator.content.index',
                        'icon' => 'fas fa-fw fa-list',
                    ],
                ],
            ],
            [
                'text' => 'Analytics',
                'route' => 'creator.analytics.index',
                'icon' => 'fas fa-fw fa-chart-bar',
                'can' => 'creator',
            ],
            [
                'text' => 'Messages',
                'route' => 'messages.index',
                'icon' => 'fas fa-fw fa-envelope',
                'can' => 'creator',
            ],
            [
                'text' => 'Settings',
                'icon' => 'fas fa-fw fa-cog',
                'can' => 'creator',
                'submenu' => [
                    [
                        'text' => 'Edit Profile',
                        'route' => 'creator.profile.edit',
                        'icon' => 'fas fa-fw fa-user-edit',
                    ],
                    [
                        'text' => 'Social Settings',
                        'route' => 'creator.settings.social',
                        'icon' => 'fas fa-fw fa-share-alt',
                    ],
                    [
                        'text' => 'Account Settings',
                        'route' => 'creator.settings.account',
                        'icon' => 'fas fa-fw fa-user-cog',
                    ],
                    [
                        'text' => 'Auto-Reply Settings',
                        'route' => 'creator.auto-replies.settings',
                        'icon' => 'fas fa-fw fa-cog',
                    ],
                ],
            ],
        ],

    /*
    |--------------------------------------------------------------------------
    | Menu Filters
    |--------------------------------------------------------------------------
    |
    | Here we can modify the menu filters of the admin panel.
    |
    | For detailed instructions you can look the menu filters section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Menu-Configuration
    |
    */

    'filters' => [
        JeroenNoten\LaravelAdminLte\Menu\Filters\GateFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\HrefFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\SearchFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\ActiveFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\ClassesFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\LangFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\DataFilter::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Plugins Initialization
    |--------------------------------------------------------------------------
    |
    | Here we can modify the plugins used inside the admin panel.
    |
    | For detailed instructions you can look the plugins section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Plugins-Configuration
    |
    */

    'plugins' => [
        'Datatables' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css',
                ],
            ],
        ],
        'Select2' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.css',
                ],
            ],
        ],
        'Chartjs' => [
            'active' => true,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.0/Chart.bundle.min.js',
                ],
            ],
        ],
        'Sweetalert2' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdn.jsdelivr.net/npm/sweetalert2@8',
                ],
            ],
        ],
        'Pace' => [
            'active' => false,
            'files' => [
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/themes/blue/pace-theme-center-radar.min.css',
                ],
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/pace.min.js',
                ],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | IFrame
    |--------------------------------------------------------------------------
    |
    | Here we change the IFrame mode configuration. Note these changes will
    | only apply to the view that extends and enable the IFrame mode.
    |
    | For detailed instructions you can look the iframe mode section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/IFrame-Mode-Configuration
    |
    */

    'iframe' => [
        'default_tab' => [
            'url' => null,
            'title' => null,
        ],
        'buttons' => [
            'close' => true,
            'close_all' => true,
            'close_all_other' => true,
            'scroll_left' => true,
            'scroll_right' => true,
            'fullscreen' => true,
        ],
        'options' => [
            'loading_screen' => 1000,
            'auto_show_new_tab' => true,
            'use_navbar_items' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Livewire
    |--------------------------------------------------------------------------
    |
    | Here we can enable the Livewire support.
    |
    | For detailed instructions you can look the livewire here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Other-Configuration
    |
    */

    'livewire' => false,
];
