<?php

namespace App\Policies;

use App\Models\SocialAccount;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class SocialAccountPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        // Users can view their own social accounts or brand accounts if they are brand admin
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, SocialAccount $socialAccount): bool
    {
        // Check if user owns the account (personal)
        if ($socialAccount->user_id && $socialAccount->user_id === $user->id) {
            return true;
        }
        
        // Check if user's brand owns the account (brand)
        if ($socialAccount->brand_id && $user->brand_id && $socialAccount->brand_id === $user->brand_id) {
            return true;
        }
        
        // Check if user's tenant owns the account (tenant-scoped)
        if ($socialAccount->tenant_id && $user->tenant_id && $socialAccount->tenant_id === $user->tenant_id) {
            return true;
        }
        
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        // Users can create social accounts for themselves or their brand
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, SocialAccount $socialAccount): bool
    {
        // Check if user owns the account (personal)
        if ($socialAccount->user_id && $socialAccount->user_id === $user->id) {
            return true;
        }
        
        // Check if user's brand owns the account (brand)
        if ($socialAccount->brand_id && $user->brand_id && $socialAccount->brand_id === $user->brand_id) {
            return true;
        }
        
        // Check if user's tenant owns the account (tenant-scoped)
        if ($socialAccount->tenant_id && $user->tenant_id && $socialAccount->tenant_id === $user->tenant_id) {
            return true;
        }
        
        return false;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, SocialAccount $socialAccount): bool
    {
        // Check if user owns the account (personal)
        if ($socialAccount->user_id && $socialAccount->user_id === $user->id) {
            return true;
        }
        
        // Check if user's brand owns the account (brand)
        if ($socialAccount->brand_id && $user->brand_id && $socialAccount->brand_id === $user->brand_id) {
            return true;
        }
        
        // Check if user's tenant owns the account (tenant-scoped)
        if ($socialAccount->tenant_id && $user->tenant_id && $socialAccount->tenant_id === $user->tenant_id) {
            return true;
        }
        
        return false;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, SocialAccount $socialAccount): bool
    {
        // Check if user owns the account (personal)
        if ($socialAccount->user_id && $socialAccount->user_id === $user->id) {
            return true;
        }
        
        // Check if user's brand owns the account (brand)
        if ($socialAccount->brand_id && $user->brand_id && $socialAccount->brand_id === $user->brand_id) {
            return true;
        }
        
        // Check if user's tenant owns the account (tenant-scoped)
        if ($socialAccount->tenant_id && $user->tenant_id && $socialAccount->tenant_id === $user->tenant_id) {
            return true;
        }
        
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, SocialAccount $socialAccount): bool
    {
        // Check if user owns the account (personal)
        if ($socialAccount->user_id && $socialAccount->user_id === $user->id) {
            return true;
        }
        
        // Check if user's brand owns the account (brand)
        if ($socialAccount->brand_id && $user->brand_id && $socialAccount->brand_id === $user->brand_id) {
            return true;
        }
        
        // Check if user's tenant owns the account (tenant-scoped)
        if ($socialAccount->tenant_id && $user->tenant_id && $socialAccount->tenant_id === $user->tenant_id) {
            return true;
        }
        
        return false;
    }
}