<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\ReelRequest;

class ReelCompletedNotification extends Notification
{
    use Queueable;

    protected $reelRequest;
    protected $status;
    protected $message;

    /**
     * Create a new notification instance.
     */
    public function __construct(ReelRequest $reelRequest, string $status, string $message = null)
    {
        $this->reelRequest = $reelRequest;
        $this->status = $status;
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     */
    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $mail = (new MailMessage)
            ->subject('Reel Processing ' . ucfirst($this->status))
            ->greeting('Hello ' . $notifiable->name . '!')
            ->line($this->message ?? 'Your reel has been ' . $this->status . '.');
            
        if ($this->status === 'completed') {
            $mail->action('View Reel', url('/creator/reels/' . $this->reelRequest->id))
                 ->line('You can now download your generated reel.');
        }
        
        return $mail;
    }

    /**
     * Get the array representation of the notification.
     */
    public function toArray(object $notifiable): array
    {
        return [
            'reel_id' => $this->reelRequest->id,
            'status' => $this->status,
            'message' => $this->message ?? 'Your reel has been ' . $this->status,
            'template' => $this->reelRequest->template,
        ];
    }
}