<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\Payment;

class PaymentProcessed extends Notification
{
    use Queueable;

    protected $payment;

    /**
     * Create a new notification instance.
     *
     * @param Payment $payment
     * @return void
     */
    public function __construct(Payment $payment)
    {
        $this->payment = $payment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('Payment Processed for Proposal: ' . $this->payment->proposal->title)
                    ->greeting('Hello ' . $notifiable->name . '!')
                    ->line('The payment for your proposal has been processed: ' . $this->payment->proposal->title)
                    ->line('Amount: $' . number_format($this->payment->amount, 2))
                    ->line('The next step is to deliver the work.')
                    ->action('View Payment Details', url('/creator/proposals/' . $this->payment->proposal->id))
                    ->line('Thank you for using our platform!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'payment_id' => $this->payment->id,
            'proposal_id' => $this->payment->proposal->id,
            'proposal_title' => $this->payment->proposal->title,
            'amount' => $this->payment->amount,
            'message' => 'The payment for your proposal has been processed: ' . $this->payment->proposal->title,
        ];
    }
}