<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProposalSection extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'proposal_id',
        'title',
        'content',
        'order',
        'is_editable',
        'edited_by',
        'edited_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_editable' => 'boolean',
        'edited_at' => 'datetime',
        'order' => 'integer',
    ];

    /**
     * Get the proposal that owns the section.
     */
    public function proposal()
    {
        return $this->belongsTo(Proposal::class);
    }

    /**
     * Get the user who last edited the section.
     */
    public function editor()
    {
        return $this->belongsTo(User::class, 'edited_by');
    }
    
    /**
     * Get the audit trail for the section.
     */
    public function audits()
    {
        return $this->hasMany(ProposalSectionAudit::class)->orderBy('created_at', 'desc');
    }
}