<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MessageThread extends Model
{
    use HasFactory;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'subject',
    ];

    /**
     * Get the participants in the thread.
     */
    public function participants()
    {
        return $this->hasMany(MessageThreadParticipant::class, 'thread_id');
    }

    /**
     * Get the messages in the thread.
     */
    public function messages()
    {
        return $this->hasMany(Message::class, 'thread_id');
    }

    /**
     * Get the latest message in the thread.
     */
    public function latestMessage()
    {
        return $this->hasOne(Message::class, 'thread_id')->latest();
    }
    
    /**
     * Get the proposal associated with the thread.
     */
    public function proposal()
    {
        return $this->belongsTo(Proposal::class);
    }
    
    /**
     * Check if the thread has been read by a specific user.
     */
    public function isReadByUser($userId)
    {
        $participant = $this->participants()->where('user_id', $userId)->first();
        return $participant ? $participant->is_read : false;
    }
}