<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContentIdea extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'brand_id',
        'creator_id',
        'campaign_id',
        'user_id',
        'caption',
        'hashtags',
        'creative_hints',
        'status',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'hashtags' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the brand that owns the content idea.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the campaign associated with the content idea.
     */
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    /**
     * Get the user who created the content idea.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    /**
     * Get the creator that owns the content idea.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
}