<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CampaignMilestone extends Model
{
    use HasFactory;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'campaign_id',
        'name',
        'description',
        'due_date',
        'budget_allocation',
        'status',
        'assigned_creator_id',
    ];
    
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'due_date' => 'date',
        'budget_allocation' => 'decimal:2',
    ];
    
    /**
     * Get the campaign that owns the milestone.
     */
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }
    
    /**
     * Get the creator assigned to the milestone.
     */
    public function assignedCreator()
    {
        return $this->belongsTo(User::class, 'assigned_creator_id');
    }
}
