<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AiJob extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'job_id',
        'type',
        'status',
        'brand_id',
        'creator_id',
        'proposal_id',
        'result_text',
        'result_meta',
        'provider',
        'error_message',
        'token_usage',
        'completed_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'result_meta' => 'array',
        'job_id' => 'string',
        'completed_at' => 'datetime',
        'token_usage' => 'integer',
    ];

    /**
     * Get the brand that owns the AI job.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the creator that owns the AI job.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }

    /**
     * Get the proposal associated with the AI job.
     */
    public function proposal()
    {
        return $this->belongsTo(Proposal::class);
    }
}